% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convmtx.R
\name{convmtx}
\alias{convmtx}
\title{Convolution matrix}
\usage{
convmtx(h, n)
}
\arguments{
\item{h}{Input, coerced to a vector, representing the filter kernel}

\item{n}{Length of vector(s) that \code{h} is to be convolved with.}
}
\value{
Convolution matrix of input \code{h} for a vector of length \code{n}.
  If \code{h} is a vector of length \code{m}, then the convolution matrix has
  \code{m + n - 1} rows and \code{n} columns.
}
\description{
Returns the convolution matrix for a filter kernel.
}
\details{
Computing a convolution using \code{conv} when the signals are vectors is
generally more efficient than using \code{convmtx}. For multichannel signals,
however, when  a large number of vectors are to be convolved with the same
filter kernel, \code{convmtx} might be more efficient.

The code \code{cm <- convmtx(h, n)} computes the convolution matrix of the
filter kernel \code{h} with a vector of length \code{n}. Then, \code{cm %*%
x} gives the convolution of \code{h} and \code{x}.
}
\examples{
N <- 1000
a <- runif(N)
b <- runif(N)
cm <- convmtx(b, N)
d <- cm \%*\% a

cref = conv(a, b)
all.equal(max(d - cref), 0)

}
\seealso{
\code{\link{conv}}
}
\author{
David Bateman \email{adb014@gmail.com}.\cr Conversion to R by Geert
  van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
