% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unwrap.R
\name{unwrap}
\alias{unwrap}
\title{Unwrap phase angles}
\usage{
unwrap(x, tol = pi)
}
\arguments{
\item{x}{Input array, specified as a vector or a matrix. If \code{x} is a
matrix, unwrapping along the columns of \code{x} is applied.}

\item{tol}{Jump threshold to apply phase shift, specified as a scalar. A jump
threshold less than \eqn{pi} has the same effect as the threshold
\eqn{pi}. Default: \deqn{pi}.}
}
\value{
Unwrapped phase angle, returned as a vector, matrix, or
  multidimensional array.
}
\description{
Unwrap radian phases by adding or subtracting multiples of \code{2 * pi}.
}
\examples{
## Define spiral shape.
t <- seq(0, 6 * pi, length.out = 201)
x <- t / pi * cos(t)
y <- t / pi * sin(t)
plot(x, y, type = "l")
## find phase angle
p = atan2(y, x)
plot(t, p, type="l")
## unwrap it
q = unwrap(p)
plot(t, q, type ="l")

}
\author{
Bill Lash.\cr
Conversion to R by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}
}
