% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_first_derivatives}
\alias{gsw_CT_first_derivatives}
\title{First Derivatives of Conservative Temperature}
\usage{
gsw_CT_first_derivatives(SA, pt)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{pt}{potential temperature (ITS-90) [ degC ]}
}
\value{
A list containing \code{CT_SA} [ K/(g/kg) ], the derivative of
Conservative Temperature with respect to Absolute Salinity,
and \code{CT_pt} [ unitless ], the derivative of
Conservative Temperature with respect to potential temperature.
}
\description{
First Derivatives of Conservative Temperature
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
pt <- c(28.7832, 28.4209, 22.7850, 10.2305,  6.8292,  4.3245)
r <- gsw_CT_first_derivatives(SA, pt)
stopifnot(all.equal(r$CT_SA,
    c(-0.041981092877806, -0.041558140199508, -0.034739209004865,
      -0.018711103772892, -0.014075941811725, -0.010571716552295)))
stopifnot(all.equal(r$CT_pt,
    c(1.002814937296636, 1.002554817053239, 1.001645140295163,
      1.000003771100520, 0.999716359504731, 0.999474326580093)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_first_derivatives.html}
}
