% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_second_derivatives}
\alias{gsw_CT_second_derivatives}
\title{Second Derivatives of Conservative Temperature}
\usage{
gsw_CT_second_derivatives(SA, pt)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{pt}{potential temperature (ITS-90) [ degC ]}
}
\value{
A list containing \code{CT_SA_SA} [ K/(g/kg)^2 ], the second derivative of
Conservative Temperature with respect to Absolute Salinity at constant
potential temperature, and \code{CT_SA_pt} [ 1/(g/kg) ], the derivative of
Conservative Temperature with respect to potential temperature and
Absolute Salinity, and \code{CT_pt_pt} [ 1/degC ], the second derivative of
Conservative Temperature with respect to potential temperature.
}
\description{
Second Derivatives of Conservative Temperature
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
pt <- c(28.7832, 28.4209, 22.7850, 10.2305,  6.8292,  4.3245)
r <- gsw_CT_second_derivatives(SA, pt)
stopifnot(all.equal(r$CT_SA_SA/1e-3, c(-0.060718502077064, -0.062065324400873, -0.084017055354742,
                                       -0.148436050120131, -0.171270386500246, -0.189920754900116)))
stopifnot(all.equal(r$CT_SA_pt, c(-0.001197415000869, -0.001198309530139, -0.001226523296082,
                                  -0.001335896286481, -0.001380492698572, -0.001417751669135)))
stopifnot(all.equal(r$CT_pt_pt/1e-3, c(0.123012754427146, 0.124662008871271, 0.140829458783443,
                                       0.140646803448166, 0.113684095615077, 0.082286843477998)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_second_derivatives.html}
}
