% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SP_from_Sstar}
\alias{gsw_SP_from_Sstar}
\title{Practical Salinity from Preformed Salinity}
\usage{
gsw_SP_from_Sstar(Sstar, p, longitude, latitude)
}
\arguments{
\item{Sstar}{Preformed Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{longitude}{longitude in decimal degrees, positive to the east of Greenwich. (This
is called \code{long} in the TEOS-10 Matlab code.)}

\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}
}
\value{
Practical Salinity (PSS-78) [ unitless ]
}
\description{
Practical Salinity from Preformed Salinity
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
Sstar <- c(34.7115, 34.8912, 35.0247, 34.8436, 34.7291, 34.7197)
p <- c(         10,      50,     125,     250,     600,    1000)
longitude <- 188
latitude <- 4
SP <- gsw_SP_from_Sstar(Sstar, p, longitude, latitude)
stopifnot(all.equal(SP, c(34.548646570969929, 34.727538423586189, 34.860549501859502,
                          34.681006826476434, 34.568065697992346, 34.560023926979518)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SP_from_Sstar.html}
}
\seealso{
Other things related to salinity: 
\code{\link{gsw_C_from_SP}()},
\code{\link{gsw_SA_from_SP}()},
\code{\link{gsw_SA_from_SP_Baltic}()},
\code{\link{gsw_SA_from_Sstar}()},
\code{\link{gsw_SP_from_C}()},
\code{\link{gsw_SP_from_SA}()},
\code{\link{gsw_SP_from_SK}()},
\code{\link{gsw_SP_from_SR}()},
\code{\link{gsw_SR_from_SP}()},
\code{\link{gsw_Sstar_from_SA}()},
\code{\link{gsw_Sstar_from_SP}()},
\code{\link{gsw_deltaSA_from_SP}()}
}
\concept{things related to salinity}
