% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_gtfs.R
\name{merge_gtfs}
\alias{merge_gtfs}
\title{Merge GTFS files}
\usage{
merge_gtfs(..., files = NULL, prefix = FALSE)
}
\arguments{
\item{...}{GTFS objects to be merged. Each argument can either be a GTFS or
a list of GTFS objects.}

\item{files}{A character vector listing the GTFS tables to be merged. If
\code{NULL} (the default), all tables are merged.}

\item{prefix}{Either a logical or a character vector (defaults to \code{FALSE}).
Whether to add a prefix to the value of id fields that identify from which
GTFS object the value comes from. If \code{TRUE}, the prefixes will range from
\code{"1"} to \code{n}, where \code{n} is the number of objects passed to the function. If a
character vector, its elements will be used to identify the GTFS objects, and
the length of the vector must equal the total amount of objects passed in
\code{...} (the first element will identify the first GTFS, the second element the
second GTFS, and so on).}
}
\value{
A GTFS object in which each table is a combination (by row) of the
tables from the specified GTFS objects.
}
\description{
Combines many GTFS objects into a single one.
}
\examples{
\dontshow{
  old_dt_threads <- data.table::setDTthreads(1)
  on.exit(data.table::setDTthreads(old_dt_threads), add = TRUE)
}
spo_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
ggl_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfstools")

spo_gtfs <- read_gtfs(spo_path)
names(spo_gtfs)

ggl_gtfs <- read_gtfs(ggl_path)
names(ggl_gtfs)

merged_gtfs <- merge_gtfs(spo_gtfs, ggl_gtfs)
names(merged_gtfs)

# use a list() to programatically merge many GTFS objects
gtfs_list <- list(spo_gtfs, ggl_gtfs)
merged_gtfs <- merge_gtfs(gtfs_list)

# 'prefix' helps disambiguating from which GTFS each id comes from.
# if TRUE, the ids range from 1:n, where n is the number of gtfs
merged_gtfs <- merge_gtfs(gtfs_list, prefix = TRUE)
merged_gtfs$agency

# if a character vector, its elements will be used to identify the each gtfs
merged_gtfs <- merge_gtfs(gtfs_list, prefix = c("spo", "ggl"))
merged_gtfs$agency
}
