% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{env_action_space_sample}
\alias{env_action_space_sample}
\title{Sample an action from the environments's action space.}
\usage{
env_action_space_sample(x, instance_id)
}
\arguments{
\item{x}{An instance of class "GymClient"; this object has "remote_base" as an attribute.}

\item{instance_id}{A short identifier (such as "3c657dbc") for the environment instance.}
}
\value{
An action sampled from a space (such as "Discrete"), which varies from space to space.
}
\description{
Sample an action from the environments's action space.
}
\examples{
\dontrun{
remote_base <- "http://127.0.0.1:5000"
client <- create_GymClient(remote_base)
env_id <- "CartPole-v0"
instance_id <- env_create(client, env_id)
env_action_space_sample(client, instance_id)
}
}

