% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3-edges.R
\name{is_nb_pairwise}
\alias{is_nb_pairwise}
\alias{is_nb_sparse}
\title{H3 index neighbors}
\usage{
is_nb_pairwise(x, y)

is_nb_sparse(x, y)
}
\arguments{
\item{x}{an \code{H3} vector.}

\item{y}{and \code{H3} vector.}
}
\value{
\code{is_nb_pairwise()} returns a logical vector wheraas \code{is_nb_sparse()} returns
a list with logical vector elements.
}
\description{
Test if two H3 cells are neighbors.
}
\examples{
cells_ids <-c(
  "85e22da7fffffff", "85e35ad3fffffff",
  "85e22daffffffff", "85e35adbfffffff",
  "85e22db7fffffff", "85e35e6bfffffff",
  "85e22da3fffffff"
)

cells <- h3o::h3_from_strings(cells_ids)

is_nb_pairwise(cells, rev(cells))
is_nb_sparse(cells, cells)
}
