% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflows.R
\name{analyze_joint}
\alias{analyze_joint}
\title{Analyze allele and expression profile}
\usage{
analyze_joint(
  bulk,
  t = 1e-05,
  gamma = 20,
  theta_min = 0.08,
  logphi_min = 0.25,
  hmm = "S15",
  nu = 1,
  min_genes = 10,
  r = 0.015,
  theta_start = 0.05,
  exclude_neu = TRUE,
  fit_gamma = FALSE,
  fit_theta = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{bulk}{dataframe Bulk allele and expression profile}

\item{t}{numeric Transition probability}

\item{gamma}{numeric Overdispersion parameter}

\item{theta_min}{numeric Minimum allele fraction}

\item{logphi_min}{numeric Minimum log2 fold change}

\item{hmm}{character HMM model to use (S7 or S15)}

\item{nu}{numeric Phase switch rate}

\item{min_genes}{integer Minimum number of genes per segment}

\item{r}{numeric Alternative allele count bias}

\item{theta_start}{numeric Starting value for theta_min}

\item{exclude_neu}{logical Whether to exclude neutral segments in retest}

\item{fit_gamma}{logical Whether to fit gamma}

\item{fit_theta}{logical Whether to fit theta_min}

\item{verbose}{logical Whether to print progress}
}
\value{
dataframe Bulk allele and expression profile with CNV states
}
\description{
Analyze allele and expression profile
}
\examples{
bulk_example = analyze_joint(bulk_example, hmm = 'S15')
}
