% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{Client}
\alias{Client}
\title{The Hakai API Client Class}
\description{
Class to use to make authenticated API requests for Hakai data.
Credentials can be provided via the HAKAI_API_TOKEN environment variable
or through a credentials file.
}
\examples{
\dontrun{
# Initialize a new client
try(
  client <- Client$new()
)

# Or use environment variable for token
Sys.setenv(HAKAI_API_TOKEN = "token_type=Bearer&access_token=TOKEN")
try(
  client <- Client$new()
)

# Follow authorization prompts to log in

# Retrieve some data. See <https://hakaiinstitute.github.io/hakai-api/> for options.
try(
  projects_2020 <- client$get("/aco/views/projects?project_year=2020&fields=project_name")
)

try(
  print(projects_2020)
)
# # A tibble: 20 x 1
#    project_name
#    <chr>
#  1 Fountain FN
#  2 Haig Glacier
#  3 Fraser River - Chimney Creek West William Canyon
#  4 Cruickshank WS
#  ...
}

## ------------------------------------------------
## Method `Client$new`
## ------------------------------------------------

try(
   client <- Client$new()
)
# Using environment variable
Sys.setenv(HAKAI_API_TOKEN = "token_type=Bearer&access_token=TOKEN")
try(
   client <- Client$new()
)
# Using custom credentials file
try(
   client <- Client$new(credentials_file = "/path/to/creds")
)

## ------------------------------------------------
## Method `Client$get`
## ------------------------------------------------

try(client$get("/aco/views/projects"))
try(client$get("https://hecate.hakai.org/api/aco/views/projects"))

## ------------------------------------------------
## Method `Client$remove_credentials`
## ------------------------------------------------

try(
   client$remove_credentials()
)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{api_root}}{The api_root you are logged in to}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Client-new}{\code{Client$new()}}
\item \href{#method-Client-get}{\code{Client$get()}}
\item \href{#method-Client-post}{\code{Client$post()}}
\item \href{#method-Client-put}{\code{Client$put()}}
\item \href{#method-Client-patch}{\code{Client$patch()}}
\item \href{#method-Client-remove_credentials}{\code{Client$remove_credentials()}}
\item \href{#method-Client-clone}{\code{Client$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-new"></a>}}
\if{latex}{\out{\hypertarget{method-Client-new}{}}}
\subsection{Method \code{new()}}{
Log into Google to gain credential access to the API
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$new(
  api_root = "https://hecate.hakai.org/api",
  login_page = "https://hecate.hakai.org/api-client-login",
  credentials_file = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_root}}{Optional API base url to fetch data.
Defaults to "https://hecate.hakai.org/api"}

\item{\code{login_page}}{Optional API login page url to display to user.
Defaults to "https://hecate.hakai.org/api-client-login"}

\item{\code{credentials_file}}{Optional path to the credentials cache file.
Defaults to a file in the user's data directory as determined by tools::R_user_dir()}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Credentials can be provided in two ways:
1. Via the HAKAI_API_TOKEN environment variable (contains query string: "token_type=Bearer&access_token=...")
2. Via a credentials file (default: in user data directory via tools::R_user_dir())
The environment variable takes precedence if both are available.
}

\subsection{Returns}{
A client instance
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{try(
   client <- Client$new()
)
# Using environment variable
Sys.setenv(HAKAI_API_TOKEN = "token_type=Bearer&access_token=TOKEN")
try(
   client <- Client$new()
)
# Using custom credentials file
try(
   client <- Client$new(credentials_file = "/path/to/creds")
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-get"></a>}}
\if{latex}{\out{\hypertarget{method-Client-get}{}}}
\subsection{Method \code{get()}}{
Send a GET request to the API
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$get(endpoint_url, col_types = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{endpoint_url}}{The API endpoint url - can be a full URL or a relative path that will be appended to the api_root}

\item{\code{col_types}}{a readr type specification}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A dataframe of the requested data
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{try(client$get("/aco/views/projects"))
try(client$get("https://hecate.hakai.org/api/aco/views/projects"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-post"></a>}}
\if{latex}{\out{\hypertarget{method-Client-post}{}}}
\subsection{Method \code{post()}}{
Send a POST request to the API
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$post(endpoint_url, rec_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{endpoint_url}}{The API endpoint url - can be a full URL or a relative path that will be appended to the api_root}

\item{\code{rec_data}}{dataframe, list, or other R data structure to send as part of the post request payload}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
post request response status code and description
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-put"></a>}}
\if{latex}{\out{\hypertarget{method-Client-put}{}}}
\subsection{Method \code{put()}}{
Send a PUT request to the API
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$put(endpoint_url, rec_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{endpoint_url}}{The API endpoint url - can be a full URL or a relative path that will be appended to the api_root}

\item{\code{rec_data}}{dataframe, list, or other R data structure to send as part of the post request payload}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
PUT request response status code and description
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-patch"></a>}}
\if{latex}{\out{\hypertarget{method-Client-patch}{}}}
\subsection{Method \code{patch()}}{
Send a PATCH request to the API
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$patch(endpoint_url, rec_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{endpoint_url}}{The API endpoint url - can be a full URL or a relative path that will be appended to the api_root}

\item{\code{rec_data}}{dataframe, list, or other R data structure to send as part of the post request payload}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
PATCH request response status code and description
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-remove_credentials"></a>}}
\if{latex}{\out{\hypertarget{method-Client-remove_credentials}{}}}
\subsection{Method \code{remove_credentials()}}{
Remove your cached login credentials to logout of the client
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$remove_credentials()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{try(
   client$remove_credentials()
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Client-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
