% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbsae.R
\name{aggr}
\alias{aggr}
\title{Compute aggregates of small area estimates and MSEs.}
\usage{
aggr(x, R)
}
\arguments{
\item{x}{sae object.}

\item{R}{aggregation matrix, M x r matrix where M is the number of areas and r
the number of aggregate areas; default is aggregation over all areas.}
}
\value{
Object of class \code{sae} with aggregated small area estimates and MSEs.
}
\description{
Compute aggregates of small area estimates and MSEs.
}
\examples{
d <- generateFakeData()

# compute small area estimates
sae <- fSAE(y0 ~ x + area2, data=d$sam, area="area", popdata=d$Xpop)

# by default aggregate over all areas
global <- aggr(sae)
EST(global); RMSE(global)

# aggregation to broad area
# first build aggregation matrix
M <- d$Xpop[, c("area22", "area23", "area24")] / d$Xpop[, "(Intercept)"]
M <- cbind(1 - rowSums(M), M); colnames(M)[1] <- "area21"
est.area2 <- aggr(sae, M)
EST(est.area2); RMSE(est.area2)
COV(est.area2)  # covariance matrix
}
\seealso{
\code{\link{sae-class}}
}
