% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.R
\name{strat_start}
\alias{strat_start}
\title{Initializes a subspace stratified design before the start of the study.}
\usage{
strat_start(p0_sub, p1_sub, distr_sub, alpha = 0.05, beta = 0.2)
}
\arguments{
\item{p0_sub}{A vector, where the $i$-th entry corresponds to the response rate under the null for the $i$-th subtype.}

\item{p1_sub}{A vector, where the $i$-th entry corresponds to the response rate under the alternative for the $i$-th subtype.}

\item{distr_sub}{A vector, where the $i$-th entry corresponds to the prevalence of the $i$-th subtype in the population.}

\item{alpha}{Specified type I error of the trial.}

\item{beta}{Specified type II error of the trial.}
}
\value{
A list returning the arguments of the function and the preliminary design for starting the stratified trial.
}
\description{
Initializes a subspace stratified design before the start of the study.
}
\examples{
p0_sub <- c(0.1, 0.3, 0.5)
p1_sub <- c(0.3, 0.5, 0.7)
distr_sub <- c(1/3, 1/3, 1/3)
strat_start(p0_sub, p1_sub, distr_sub)
}
