% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_data.R
\name{HDCATE.get_sim_data}
\alias{HDCATE.get_sim_data}
\title{Get simulation data}
\usage{
HDCATE.get_sim_data(
  n_obs = 500,
  n_var = 100,
  n_rel_var = 4,
  sig_strength_propensity = 0.5,
  sig_strength_outcome = 1,
  intercept = 10
)
}
\arguments{
\item{n_obs}{Num of observations}

\item{n_var}{Num of covariates}

\item{n_rel_var}{Num of relevant variables, only the first \code{n_rel_var} covariates are actually present in the expectation function of potential outcome, and only the last \code{n_rel_var} covariates are present in the propensity score function.}

\item{sig_strength_propensity}{signal strength in propensity score functions}

\item{sig_strength_outcome}{signal strength in outcome functions}

\item{intercept}{value of intercept in outcome functions}
}
\value{
a data.frame, which is the simulated observed data.
}
\description{
Get simulation data
}
\examples{
HDCATE.get_sim_data()
HDCATE.get_sim_data(n_obs=50, n_var=4, n_rel_var=2)
}
