% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hds_lc_hat.R
\name{hdslc.fast}
\alias{hdslc.fast}
\title{Hazard discrimination summary estimate (local constant) at one time point}
\usage{
hdslc.fast(S, betahat, m)
}
\arguments{
\item{S}{A vector of length \code{nrow(m)} (which is typically the number of
observations n), where each value is the subject-specific survival at time t
where t is implied by the choice of \code{betahat}.}

\item{betahat}{A p x 1 vector of coefficient estimates at time t of interest
from the local-in-time Cox model. Vector length p is the number of
covariates. Typically the output from \code{hdslc::finda} is passed here.}

\item{m}{A numeric n x p matrix of covariate values, with a column for each
covariate and each observation is on a separate row.}
}
\value{
The HDS estimate at times t, where t is implied by choice of \code{S}
and \code{betahat} passed to \code{hdslc.fast}.
}
\description{
\code{hdslc.fast} estimates HDS at a single time using the local-in-time
proportional hazards model. See Cai and Sun (2003, Scandinavian Journal of
Statistics) for details on the local-in-time PH model.
}
\details{
The user typically will not interact with this function. Rather, \code{hdslc}
wraps this function and is what the user typically will use.
}

