% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdsvm-methods.R
\name{predict.hdsvm}
\alias{predict.hdsvm}
\title{Make Predictions from a `hdsvm` Object}
\usage{
\method{predict}{hdsvm}(object, newx, s = NULL, type = c("class", "loss"), ...)
}
\arguments{
\item{object}{Fitted `hdsvm()` object from which predictions are to be derived.}

\item{newx}{Matrix of new predictor values for which predictions are desired.
This must be a matrix and is a required argument.}

\item{s}{Values of the penalty parameter `lambda` for which predictions are requested.
Defaults to the entire sequence used during the model fit.}

\item{type}{Type of prediction required. Type `"class"` produces the predicted binary class labels and
type `"loss"` returns the fitted values. Default is \code{"class"}.}

\item{...}{Not used.}
}
\value{
Returns a vector or matrix of predicted values corresponding to the specified `lambda` values.
}
\description{
Produces fitted values for new predictor data using a fitted `hdsvm()` object.
}
\details{
This function generates predictions at specified `lambda` values from a fitted `hdsvm()` object.
It is essential to provide a new matrix of predictor values (`newx`) at which these predictions are to be made.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x1 <- matrix(rnorm(n / 2 * p, -0.25, 0.1), n / 2)
x2 <- matrix(rnorm(n / 2 * p, 0.25, 0.1), n / 2)
x <- rbind(x1, x2)
beta <- 0.1 * rnorm(p)
prob <- plogis(c(x \%*\% beta))
y <- 2 * rbinom(n, 1, prob) - 1
lam2 <- 0.01
fit <- hdsvm(x, y, lam2=lam2)
preds <- predict(fit, newx = tail(x), s = fit$lambda[3:5])
}
\seealso{
\code{\link{hdsvm}}, \code{\link{coef.hdsvm}}
}
