% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{MEPS2001}
\alias{MEPS2001}
\title{Medical Expenditure Panel Survey (MEPS) Data}
\format{
A data frame with 3328 observations on the following variables:
\itemize{
\item{educ: Education status (numeric)}
\item{age: Age (numeric)}
\item{income: Income (numeric)}
\item{female: Gender (binary)}
\item{vgood: Self-reported health status, very good (numeric)}
\item{good: Self-reported health status, good (numeric)}
\item{hospexp: Hospital expenditures (numeric)}
\item{totchr: Total number of chronic diseases (numeric)}
\item{ffs: Family support (numeric)}
\item{dhospexp: Dummy variable for hospital expenditures (binary)}
\item{age2: Age squared (numeric)}
\item{agefem: Interaction between age and gender (numeric)}
\item{fairpoor: Self-reported health status, fair or poor (numeric)}
\item{year01: Year of survey (numeric)}
\item{instype: Type of insurance (numeric)}
\item{ambexp: Ambulatory expenditures (numeric)}
\item{lambexp: Log of ambulatory expenditures (numeric)}
\item{blhisp: Ethnicity (binary)}
\item{instype_s1: Insurance type, version 1 (numeric)}
\item{dambexp: Dummy variable for ambulatory expenditures (binary)}
\item{lnambx: Log-transformed ambulatory expenditures (numeric)}
\item{ins: Insurance status (binary)}
}
}
\source{
2001 Medical Expenditure Panel Survey by the Agency for Healthcare
Research and Quality.
}
\usage{
MEPS2001
}
\description{
The MEPS dataset contains large-scale survey data from the United States,
focusing on health services usage, costs, and insurance coverage. This dataset
is restricted to individuals aged 21 to 64 years. It includes outpatient cost
data with some zero expenditure values for model adjustment.
}
\examples{
data(MEPS2001)
selectEq  <- dambexp ~ age + female + educ + blhisp + totchr + ins + income
outcomeEq <- lnambx ~ age + female + educ + blhisp + totchr + ins
dispersion  <- ~ age + female + totchr + ins
correlation  <- ~ age
fit <- heckmanGE(selection = selectEq,
                outcome = outcomeEq,
                dispersion = dispersion,
                correlation = correlation,
                data = MEPS2001)
summary(fit)
}
\keyword{datasets}
