#' @rdname hero
#' @export
hero.prepared_array = function(x, ...) {
  lambda = exp(x$loglambda)
  parts = lapply(seq_along(lambda), function(i) {
    x$Q[[i]] %*% x$U[[i]] %*% diag(1/(1 + lambda[i]*x$s[[i]]))
  })
  coeffs = rh.seq(parts, x$Ytilde)
  fitted = rh.seq(x$B, coeffs)
  out = list(fitted = fitted, coefficients = coeffs, x = x$x)
  class(out) = c("hero_array", "hero")
  return(out)
}


