% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacent.R
\name{adjacent}
\alias{adjacent}
\title{Determine adjacent points}
\usage{
adjacent(coords, longlat = FALSE, digits = 1)
}
\arguments{
\item{coords}{A two-dimensional matrix-like object with
non-NULL dimensions.}

\item{longlat}{A logical value indicating whether Great
Circle distances should be used (\code{TRUE}) or
Euclidean distances (\code{FALSE}).  The default is
\code{FALSE}.}

\item{digits}{The number of digits to use when applying
\code{\link[base]{round}} to the distances.}
}
\value{
A \code{hero_adjacent} object.  This is simply a
  list with elements \code{nbrs} and \code{coords}.
  \code{nbrs} is a list specifying the adjacent points
  for each point.  \code{coords} is simply the original
  \code{coords} supplied to the function and is retained
  for plotting purposes.
}
\description{
\code{adjacent} attempts to find the point(s) adjacent
(closest) to each point.  The data are implicitly assumed
to be on a grid, otherwise this function isn't very
useful. Distances between each point and other points in
\code{coords} are computed and then rounded using the
\code{\link[base]{round}} function. Let \code{k} denote
the minimum distance between a reference point and all
other points.  A point is adjacent to the reference point
if (after rounding), it's distance from the reference
point matches the minimum distance \code{k}.
}
\details{
\code{digits} is the number of digits used by
\code{\link[base]{round}} in the rounding process.
}
\examples{
# basic coordinates
coords = expand.grid(1:4, 1:4)
# plot coordinates to see relationships
plot(coords, type = "n")
text(coords)
a = adjacent(coords, digits = 1)
plot(a)
}
