% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand.R
\name{fast_rgengamma}
\alias{fast_rgengamma}
\title{Random generation for generalized gamma distribution}
\usage{
fast_rgengamma(n, mu = 0, sigma = 1, Q)
}
\arguments{
\item{n}{Number of random observations to draw.}

\item{mu}{Vector of location parameters.
and columns correspond to rates during specified time intervals.}

\item{sigma}{Vector of scale parameters as described in \code{flexsurv}.}

\item{Q}{Vector of shape parameters.}
}
\value{
A vector of random samples from the generalized gamma distribution. The length of the sample is
determined by n. The numerical arguments other than n are recycled so that the number of samples is
equal to n.
}
\description{
Draw random samples from a generalized gamma distribution using the
parameterization from \code{flexsurv}. Written in C++
for speed. Equivalent to \code{flexsurv::rgengamma}.
}
\examples{
n <- 1000
m <- 2 ; s <- 1.7; q <- 1
ptm <- proc.time()
r1 <- fast_rgengamma(n, mu = m, sigma = s, Q = q)
proc.time() - ptm
ptm <- proc.time()
library("flexsurv")
r2 <- flexsurv::rgengamma(n, mu = m, sigma = s, Q = q)
proc.time() - ptm
summary(r1)
summary(r2)

}
