% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C2pop.R
\name{C2pop}
\alias{C2pop}
\title{Adapt a Contact Matrix to Population Fractions}
\usage{
C2pop(C, target, eps = 0.001, iter.max = 100)
}
\arguments{
\item{C}{a square numeric (contact) matrix.}

\item{target}{the stationary probability vector to approximate.}

\item{eps}{the tolerated mean absolute difference between the target
probabilities and the stationary distribution of the adapted, normalized
contact matrix.}

\item{iter.max}{maximum number of iterations (guard against infinite loop).}
}
\value{
the adapted, normalized contact matrix.
}
\description{
\strong{Experimental} function, which tries to adjust a given contact matrix
such that the stationary distribution of its row-normalized version (i.e.,
the transition matrix) becomes approximately equal to a prespecified
probability vector.
}
\examples{
GROUPING <- c(1, 2, 2, 4, 4, 2)
C <- contactmatrix(grouping = GROUPING)
popBErbyg <- aggregateCountsArray(pop2011, dim = 2, grouping = GROUPING)
popfracs <- prop.table(colSums(popBErbyg))
## adapt 'C' to the given population fractions
Cpop <- C2pop(C, popfracs)
## compare the stationary distributions
compstat <- cbind(before = stationary(C/rowSums(C)), popBE = popfracs,
                  after = stationary(Cpop))
matplot(compstat, type="b", lty=1, ylim=c(0, max(compstat)),
        xlab="age group", ylab="population fraction")
## compare the normalized contact matrices
print(plotC(C/rowSums(C), main="original", at=seq(0,0.6,length.out=17)),
      split=c(1,1,2,1), more=TRUE)
print(plotC(Cpop, main="adapted", at=seq(0,0.6,length.out=17)),
      split=c(2,1,2,1), more=FALSE)
}
\seealso{
\code{\link{adaptP}} for an alternative method.
}
\author{
Leonhard Held (original) and Sebastian Meyer (this implementation)
}
