% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hidecan_plot.R
\name{hidecan_plot}
\alias{hidecan_plot}
\title{Wrapper to create a HIDECAN plot}
\usage{
hidecan_plot(
  gwas_list = NULL,
  de_list = NULL,
  can_list = NULL,
  score_thr_gwas = 4,
  score_thr_de = 2,
  log2fc_thr = 1,
  chrom_length = NULL,
  colour_genes_by_score = TRUE,
  remove_empty_chrom = FALSE,
  chroms = NULL,
  chrom_limits = NULL,
  title = NULL,
  subtitle = NULL,
  n_rows = NULL,
  n_cols = 2,
  legend_position = "bottom",
  point_size = 3,
  label_size = 3.5,
  label_padding = 0.15
)
}
\arguments{
\item{gwas_list}{Data-frame or list of data-frames containing GWAS results,
each with at least a \code{chromosome}, \code{position} and either \code{padj} or \code{score}
columns. If a named list, the names will be used in the plot.}

\item{de_list}{Data-frame or list of data-frames containing DE results,
each with at least a \code{chromosome}, \code{start}, \code{end}, \code{log2FoldChange} and
either \code{padj} or \code{score} columns. If a named list, the names will be used in
the plot.}

\item{can_list}{Data-frame or list of data-frames containing candidate genes,
each with at least a \code{chromosome}, \code{start}, \code{end} and \code{name} columns. If a
named list, the names will be used in the plot.}

\item{score_thr_gwas}{Numeric, the score threshold for GWAS results that will be used to
select which markers will be plotted. Default value is 4.}

\item{score_thr_de}{Numeric, the score threshold for DE results that will be used to
select which markers will be plotted. Default value is 2.}

\item{log2fc_thr}{Numeric, the log2(fold-change) threshold that will be used
to select which genes will be plotted. Default value is 1.}

\item{chrom_length}{Optional, tibble with columns \code{chromosome} and \code{length},
giving for each chromosome its length in bp. If \code{NULL} (the default), will
be inferred from the GWAS, DE and candidate gene data.}

\item{colour_genes_by_score}{Logical, whether to colour the genes by score
(\code{TRUE}) or by log2(fold-change) (\code{FALSE}). Default value is \code{TRUE}.}

\item{remove_empty_chrom}{Logical, should chromosomes with no significant
markers/genes nor candidate genes be removed from the plot? Default value
if \code{FALSE}.}

\item{chroms}{Character vector, name of chromosomes to include in the plot.}

\item{chrom_limits}{Integer vector of length 2, or named list where the
elements are integer vectors of length 2. If vector, gives the lower and upper
limit of the chromosomes (in bp) to use in the plot. If a named list, names
should correspond to chromosome names. Gives for each chromosome the lower
and upper limits (in bp) to use in the plot. Doesn't have to be specified
for all chromosomes. Default value is \code{NULL}, i.e. no limits are applied
to the chromosomes (they will be plotted in their entirety).}

\item{title}{Character, title of the plot. Default value is \code{NULL} (i.e.
no title will be added to the plot).}

\item{subtitle}{Character, subtitle of the plot. Default value is \code{NULL}
(i.e. no subtitle will be added to the plot).}

\item{n_rows}{Integer, number of rows of chromosomes to create in the plot.
Default value is \code{NULL}.}

\item{n_cols}{Integer, number of columns of chromosomes to create in the plot.
Default value is 2. Will be set to \code{NULL} if \code{n_rows} is not \code{NULL}.}

\item{legend_position}{Character, position of the legend in the plot. Can be
\code{bottom} (default value), \code{top}, \code{right}, \code{left} or \code{none}.}

\item{point_size}{Numeric, size of the points in the plot. Default value is 3.}

\item{label_size}{Numeric, size of the gene labels in the plot. Default value is
3.5 (for \code{\link[ggrepel]{geom_label_repel}}).}

\item{label_padding}{Numeric, amount of padding around gene labels in the plot,
as unit or number. Default value is 0.15
(for \link[ggrepel]{geom_label_repel}).}
}
\value{
a \code{ggplot}.
}
\description{
Wrapper function to create a HIDECAN plot from GWAS results,
DE results or candidate genes.
}
\examples{
if (interactive()) {
x <- get_example_data()

## Typical example with one GWAs result table, one DE result table and
## one table of candidate genes
hidecan_plot(gwas_list = x[["GWAS"]],
             de_list = x[["DE"]],
             can_list = x[["CAN"]],
             score_thr_gwas = -log10(0.0001),
             score_thr_de = -log10(0.005),
             log2fc_thr = 0,
             label_size = 2)

## Example with two sets of GWAS results
hidecan_plot(gwas_list = list(x[["GWAS"]], x[["GWAS"]]),
             score_thr_gwas = 4)

## Example with two sets of DE results, with names
hidecan_plot(de_list = list("X vs Y" = x[["DE"]],
                            "X vs Z" = x[["DE"]]),
             score_thr_de = -log10(0.05),
             log2fc_thr = 0)

## Set limits on all chromosomes (to "zoom in" to the 10-20Mb region)
hidecan_plot(gwas_list = x[["GWAS"]],
             de_list = x[["DE"]],
             can_list = x[["CAN"]],
             score_thr_gwas = -log10(0.0001),
             score_thr_de = -log10(0.005),
             log2fc_thr = 0,
             label_size = 2,
             chrom_limits = c(10e6, 20e6))

## Set limits on some chromosomes only
hidecan_plot(gwas_list = x[["GWAS"]],
             de_list = x[["DE"]],
             can_list = x[["CAN"]],
             score_thr_gwas = -log10(0.0001),
             score_thr_de = -log10(0.005),
             log2fc_thr = 0,
             label_size = 2,
             chrom_limits = list("ST4.03ch00" = c(10e6, 20e6),
                                  "ST4.03ch02" = c(15e6, 25e6)))
}
}
