% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiparametric_sdr.R
\name{semi.phd}
\alias{semi.phd}
\title{Semiparametric PHD SDR fitting function}
\usage{
semi.phd(
  x,
  y,
  d = 5L,
  maxit = 100L,
  h = NULL,
  opt.method = c("lbfgs.x", "bfgs", "lbfgs2", "bfgs.x", "lbfgs", "spg", "ucminf", "CG",
    "nlm", "nlminb", "newuoa"),
  nn = 0.95,
  init.method = c("random", "phd"),
  optimize.nn = FALSE,
  verbose = TRUE,
  n.samples = 100,
  degree = 2,
  vic = TRUE,
  ...
)
}
\arguments{
\item{x}{an n x p matrix of covariates, where each row is an observation and each column is a predictor}

\item{y}{vector of responses of length n}

\item{d}{an integer representing the structural dimension}

\item{maxit}{maximum number of iterations}

\item{h}{bandwidth parameter. By default, a reasonable choice is selected automatically}

\item{opt.method}{optimization method to use. Available choices are
\code{c("lbfgs2", "lbfgs.x", "bfgs.x", "bfgs", "lbfgs", "spg", "ucminf", "CG", "nlm", "nlminb", "newuoa")}}

\item{nn}{nearest neighbor parameter for \code{\link[locfit]{locfit.raw}}}

\item{init.method}{method for parameter initialization. Either \code{"random"} for random initialization or \code{"phd"}
for a principle Hessian directions initialization approach}

\item{optimize.nn}{should \code{nn} be optimized? Not recommended}

\item{verbose}{should results be printed along the way?}

\item{n.samples}{number of samples for the random initialization method}

\item{degree}{degree of kernel to use}

\item{vic}{logical value of whether or not to compute the VIC criterion for dimension determination}

\item{...}{extra arguments passed to \code{\link[locfit]{locfit.raw}}}
}
\value{
A list with the following elements
\itemize{
\item beta estimated sufficient dimension reduction matrix
\item beta.init initial sufficient dimension reduction matrix -- do not use, just for the sake of comparisons
\item cov variance covariance matric for the covariates
\item sqrt.inv.cov inverse square root of the variance covariance matrix for the covariates. Used for scaling
\item solver.obj object returned by the solver/optimization function
\item vic the penalized VIC value. This is used for dimension selection, with dimension chosen to
minimize this penalized vic value that trades off model complexity and model fit
}
}
\description{
fits semiparametric SDR models (PHD approach)
}
