% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highmaps.R
\name{hc_add_series_map}
\alias{hc_add_series_map}
\title{Add a map series}
\usage{
hc_add_series_map(hc, map, df, value, joinBy, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{map}{A \code{list} object loaded from a geojson file.}

\item{df}{A \code{data.frame} object with data to chart. Code region and value are
required.}

\item{value}{A string value with the name of the variable to chart.}

\item{joinBy}{What property to join the  \code{map} and \code{df}}

\item{...}{Additional shared arguments for the data series
(\url{https://api.highcharts.com/highcharts/series}).}
}
\description{
Add a map series
}
\details{
This function force the highchart object to be map type.
}
\examples{

library("dplyr")

data("USArrests", package = "datasets")
data("usgeojson")

USArrests <- mutate(USArrests, state = rownames(USArrests))

highchart() \%>\%
  hc_title(text = "Violent Crime Rates by US State") \%>\%
  hc_subtitle(text = "Source: USArrests data") \%>\%
  hc_add_series_map(usgeojson, USArrests,
    name = "Murder arrests (per 100,000)",
    value = "Murder", joinBy = c("woename", "state"),
    dataLabels = list(
      enabled = TRUE,
      format = "{point.properties.postalcode}"
    )
  ) \%>\%
  hc_colorAxis(stops = color_stops()) \%>\%
  hc_legend(valueDecimals = 0, valueSuffix = "\%") \%>\%
  hc_mapNavigation(enabled = TRUE)
\dontrun{

data(worldgeojson, package = "highcharter")
data("GNI2014", package = "treemap")

highchart(type = "map") \%>\%
  hc_add_series_map(map = worldgeojson, df = GNI2014, value = "GNI", joinBy = "iso3") \%>\%
  hc_colorAxis(stops = color_stops()) \%>\%
  hc_tooltip(
    useHTML = TRUE, headerFormat = "",
    pointFormat = "this is {point.name} and have {point.population} people with gni of {point.GNI}"
  )
}

}
