% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_mcmc_hierarchical.R
\name{hb_mcmc_hierarchical}
\alias{hb_mcmc_hierarchical}
\title{Hierarchical model MCMC}
\usage{
hb_mcmc_hierarchical(
  data,
  response = "response",
  study = "study",
  study_reference = max(data[[study]]),
  group = "group",
  group_reference = min(data[[group]]),
  patient = "patient",
  covariates = grep("^covariate", colnames(data), value = TRUE),
  s_delta = 30,
  s_beta = 30,
  s_sigma = 30,
  s_mu = 30,
  s_tau = sd(data[[response]], na.rm = TRUE),
  d_tau = 1,
  prior_tau = "half_t",
  n_chains = 4,
  n_adapt = 2000,
  n_warmup = 4000,
  n_iterations = 20000,
  quiet = TRUE
)
}
\arguments{
\item{data}{Tidy data frame with one row per patient,
indicator columns for the response variable,
study, group, and patient,
and covariates. All columns must be atomic vectors
(e.g. not lists). The data for the mixture and simple models
should have just one study,
and the others should have
data from more than one study. The simple model can be used
to get the historical data components of \code{m_omega} and \code{s_omega}
for the mixture model.}

\item{response}{Character of length 1,
name of the column in \code{data} with the response/outcome variable.
\code{data[[response]]} must be a continuous variable,
and it \emph{should} be the change from baseline of a
clinical endpoint of interest, as opposed to just
the raw response. Treatment differences
are computed directly from this scale, please supply
change from baseline unless you are absolutely certain
that treatment differences computed directly from
this quantity are clinically meaningful.}

\item{study}{Character of length 1,
name of the column in \code{data} with the study ID.}

\item{study_reference}{Atomic of length 1,
element of the \code{study} column that indicates
the current study.
(The other studies are historical studies.)}

\item{group}{Character of length 1,
name of the column in \code{data} with the group ID.}

\item{group_reference}{Atomic of length 1,
element of the \code{group} column that indicates
the control group.
(The other groups may be treatment groups.)}

\item{patient}{Character of length 1,
name of the column in \code{data} with the patient ID.}

\item{covariates}{Character vector of column names
in \code{data} with the columns with baseline covariates.
These can be continuous, categorical, or binary.
Regardless, \code{historicalborrow} derives the appropriate
model matrix.}

\item{s_delta}{Numeric of length 1, prior standard deviation
of the study-by-group effect parameters \code{delta}.}

\item{s_beta}{Numeric of length 1, prior standard deviation
of the fixed effects \code{beta}.}

\item{s_sigma}{Numeric of length 1, prior upper bound
of the residual standard deviations.}

\item{s_mu}{Numeric of length 1,
prior standard deviation of \code{mu}.}

\item{s_tau}{Non-negative numeric of length 1.
If \code{prior_tau} is \code{"half_t"}, then \code{s_tau} is the scale parameter of
the Student t prior of \code{tau} and analogous to the \code{sigma} parameter of
the Student-t parameterization given at
\url{https://mc-stan.org/docs/functions-reference/unbounded_continuous_distributions.html}. # nolint
If \code{prior_tau} is \code{"uniform"}, then \code{s_tau} is the upper bound of \code{tau}.
Upper bound on \code{tau} if \code{prior_tau} is \code{"uniform"}.

In the case of \code{prior_tau} equal to \code{"half_t"}, the defaults
\code{s_tau = sd(data[[response]], na.rm = TRUE)} and
\code{d_tau = 1}  specify a weakly informative scaled half-Cauchy
distribution. This choice is only provisional.
The prior on \code{tau} is extremely important, especially for small
numbers of historical studies, and the user should set a reasonable
value for the use case, ideally informed by the results of sensitivity
analyses and simulations.}

\item{d_tau}{Positive numeric of length 1. Degrees of freedom of the
Student t prior of \code{tau} if \code{prior_tau} is \code{"half_t"}.

In the case of \code{prior_tau} equal to \code{"half_t"}, the defaults
\code{s_tau = sd(data[[response]], na.rm = TRUE)} and
\code{d_tau = 1}  specify a weakly informative scaled half-Cauchy
distribution. This choice is only provisional.
The prior on \code{tau} is extremely important, especially for small
numbers of historical studies, and the user should set a reasonable
value for the use case, ideally informed by the results of sensitivity
analyses and simulations.}

\item{prior_tau}{Character string, family of the prior of \code{tau}.
If \code{prior_tau} equals \code{"uniform"}, then the prior on \code{tau} is
a uniform prior with lower bound 0 and upper bound \code{s_tau}.
If \code{prior_tau} equals \code{"half_t"}, then the prior on \code{tau} is a
half Student-t prior with center 0, lower bound 0, scale parameter
\code{s_tau}, and degrees of freedom \code{d_tau}. The scale parameter \code{s_tau}
is analogous to the \code{sigma} parameter of
the Student-t parameterization given at
\url{https://mc-stan.org/docs/functions-reference/unbounded_continuous_distributions.html}. # nolint}

\item{n_chains}{Number of MCMC chains to run.}

\item{n_adapt}{Number of adaptation iterations to run.}

\item{n_warmup}{Number of warmup iterations per chain to run.}

\item{n_iterations}{Number of saved MCMC iterations per chain to run.}

\item{quiet}{Logical of length 1, \code{TRUE} to suppress R console output.}
}
\value{
A tidy data frame of parameter samples from the
posterior distribution. Columns \code{.chain}, \code{.iteration},
and \code{.draw} have the meanings documented in the
\code{posterior} package.
}
\description{
Run the hierarchical model with MCMC.
}
\examples{
if (!identical(Sys.getenv("HB_TEST", unset = ""), "")) {
data <- hb_sim_hierarchical(n_continuous = 2)$data
hb_mcmc_hierarchical(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 50,
  n_iterations = 50
)
}
}
\seealso{
Other mcmc: 
\code{\link{hb_convergence}()},
\code{\link{hb_mcmc_independent}()},
\code{\link{hb_mcmc_mixture}()},
\code{\link{hb_mcmc_mixture_hyperparameters}()},
\code{\link{hb_mcmc_pool}()}
}
\concept{mcmc}
