% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_mcmc_mixture_hyperparameters.R
\name{hb_mcmc_mixture_hyperparameters}
\alias{hb_mcmc_mixture_hyperparameters}
\title{Mixture model MCMC hyperparameters}
\usage{
hb_mcmc_mixture_hyperparameters(
  data,
  response = "response",
  study = "study",
  study_reference = max(data[[study]]),
  group = "group",
  group_reference = min(data[[group]]),
  patient = "patient",
  m_mu = 0,
  s_mu = 30,
  s_sigma = 30,
  m_omega_current = 0,
  s_omega_current = 30,
  n_chains = 4,
  n_adapt = 2000,
  n_warmup = 4000,
  n_iterations = 20000,
  quiet = TRUE
)
}
\arguments{
\item{data}{Tidy data frame with one row per patient,
indicator columns for the response variable,
study, group, and patient,
and covariates. All columns must be atomic vectors
(e.g. not lists). The data for the mixture and simple models
should have just one study,
and the others should have
data from more than one study. The simple model can be used
to get the historical data components of \code{m_omega} and \code{s_omega}
for the mixture model.}

\item{response}{Character of length 1,
name of the column in \code{data} with the response/outcome variable.
\code{data[[response]]} must be a continuous variable,
and it \emph{should} be the change from baseline of a
clinical endpoint of interest, as opposed to just
the raw response. Treatment differences
are computed directly from this scale, please supply
change from baseline unless you are absolutely certain
that treatment differences computed directly from
this quantity are clinically meaningful.}

\item{study}{Character of length 1,
name of the column in \code{data} with the study ID.}

\item{study_reference}{Atomic of length 1,
element of the \code{study} column that indicates
the current study.
(The other studies are historical studies.)}

\item{group}{Character of length 1,
name of the column in \code{data} with the group ID.}

\item{group_reference}{Atomic of length 1,
element of the \code{group} column that indicates
the control group.
(The other groups may be treatment groups.)}

\item{patient}{Character of length 1,
name of the column in \code{data} with the patient ID.}

\item{m_mu}{Numeric of length 1, prior mean of the mean \code{mu} in
the simple model.}

\item{s_mu}{Numeric of length 1, prior standard deviation of the
mean \code{mu} in the simple model.}

\item{s_sigma}{Numeric of length 1, uniform prior upper bound
of the residual standard deviation \code{sigma} in the simple model.}

\item{m_omega_current}{Numeric with length 1,
\code{m_omega} value of the current study.
Inserted as the final component of the \code{m_omega} column in the output.}

\item{s_omega_current}{Numeric with length 1,
\code{s_omega} value of the current study.
Inserted as the final component of the \code{s_omega} column in the output.}

\item{n_chains}{Number of MCMC chains to run.}

\item{n_adapt}{Number of adaptation iterations to run.}

\item{n_warmup}{Number of warmup iterations per chain to run.}

\item{n_iterations}{Number of saved MCMC iterations per chain to run.}

\item{quiet}{Logical of length 1, \code{TRUE} to suppress R console output.}
}
\value{
A tidy data frame of hyperparameter values for \code{\link[=hb_mcmc_mixture]{hb_mcmc_mixture()}}.
The first several rows are for historical studies, and the last row
is for the current study. Studies/rows are sorted in the order
\code{\link[=hb_mcmc_mixture]{hb_mcmc_mixture()}} sorts them, so you can use columns \code{m_omega}
and \code{s_omega} for the same dataset and same values of other arguments
directly in \code{\link[=hb_mcmc_mixture]{hb_mcmc_mixture()}}.
}
\description{
Run a simple model separately on each historical study
control group and compute hyperparameters for \code{\link[=hb_mcmc_mixture]{hb_mcmc_mixture()}}.
}
\details{
The model is a simple Bayesian model with a normal likelihood,
an unknown mean \code{mu}, and an unknown standard deviation \code{sigma}.
For each historical study, the posterior mean of \code{mu} becomes
the corresponding component of \code{m_omega} in the output,
and the posterior standard deviation of \code{mu}
becomes the corresponding component of \code{s_omega} in the output.
See the examples in this help file for a demonstration.
\code{m_omega} and \code{s_omega} define the components of the mixture prior
in \code{\link[=hb_mcmc_mixture]{hb_mcmc_mixture()}} that act as the contribution of the
historical studies to the model.
}
\examples{
data_all_studies <- hb_sim_independent(n_continuous = 2)$data
data_all_studies$study <- paste0("study", data_all_studies$study)
hyperparameters <- hb_mcmc_mixture_hyperparameters(
  data = data_all_studies,
  response = "response",
  study = "study",
  study_reference = "study5",
  group = "group",
  group_reference = 1,
  patient = "patient",
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 50,
  n_iterations = 50
)
print(hyperparameters)
data_current_study <- dplyr::filter(data_all_studies, study == max(study))
hb_mcmc_mixture(
  data = data_current_study,
  response = "response",
  study = "study",
  study_reference = "study5",
  group = "group",
  group_reference = 1,
  patient = "patient",
  m_omega = hyperparameters$m_omega, # use hyperparams from historical data
  s_omega = hyperparameters$s_omega, # use hyperparams from historical data
  p_omega = rep(1 / nrow(hyperparameters), nrow(hyperparameters)),
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 50,
  n_iterations = 50
)
}
\seealso{
Other mcmc: 
\code{\link{hb_convergence}()},
\code{\link{hb_mcmc_hierarchical}()},
\code{\link{hb_mcmc_independent}()},
\code{\link{hb_mcmc_mixture}()},
\code{\link{hb_mcmc_pool}()}
}
\concept{mcmc}
