% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_summary.R
\name{hb_summary}
\alias{hb_summary}
\title{Model summary}
\usage{
hb_summary(
  mcmc,
  data,
  response = "response",
  study = "study",
  study_reference = max(data[[study]]),
  group = "group",
  group_reference = min(data[[group]]),
  patient = "patient",
  covariates = grep("^covariate", colnames(data), value = TRUE),
  eoi = 0,
  direction = "<"
)
}
\arguments{
\item{mcmc}{A wide data frame of posterior samples returned by
\code{\link[=hb_mcmc_hierarchical]{hb_mcmc_hierarchical()}} or similar MCMC function.}

\item{data}{Tidy data frame with one row per patient,
indicator columns for the response variable,
study, group, and patient,
and covariates. All columns must be atomic vectors
(e.g. not lists). The data for the mixture and simple models
should have just one study,
and the others should have
data from more than one study. The simple model can be used
to get the historical data components of \code{m_omega} and \code{s_omega}
for the mixture model.}

\item{response}{Character of length 1,
name of the column in \code{data} with the response/outcome variable.
\code{data[[response]]} must be a continuous variable,
and it \emph{should} be the change from baseline of a
clinical endpoint of interest, as opposed to just
the raw response. Treatment differences
are computed directly from this scale, please supply
change from baseline unless you are absolutely certain
that treatment differences computed directly from
this quantity are clinically meaningful.}

\item{study}{Character of length 1,
name of the column in \code{data} with the study ID.}

\item{study_reference}{Atomic of length 1,
element of the \code{study} column that indicates
the current study.
(The other studies are historical studies.)}

\item{group}{Character of length 1,
name of the column in \code{data} with the group ID.}

\item{group_reference}{Atomic of length 1,
element of the \code{group} column that indicates
the control group.
(The other groups may be treatment groups.)}

\item{patient}{Character of length 1,
name of the column in \code{data} with the patient ID.}

\item{covariates}{Character vector of column names
in \code{data} with the columns with baseline covariates.
These can be continuous, categorical, or binary.
Regardless, \code{historicalborrow} derives the appropriate
model matrix.}

\item{eoi}{Numeric of length at least 1,
vector of effects of interest (EOIs) for critical success factors (CSFs).}

\item{direction}{Character of length \code{length(eoi)} indicating how
to compare the treatment effect to each EOI. \code{">"} means
Prob(treatment effect > EOI), and \code{"<"} means
Prob(treatment effect < EOI). All elements of \code{direction}
must be either \code{">"} or \code{"<"}.}
}
\value{
A tidy data frame with one row per group (e.g. treatment arm)
and the columns in the following list. Unless otherwise specified,
the quantities are calculated at the group level.
Some are calculated for the current (non-historical) study only,
while others pertain to the combined dataset which includes
all historical studies.
The mixture model is an exception because the \code{data} argument
only includes the current study, so other quantities that include
historical information will need to borrow from an \code{hb_summary()}
call on one of the other models.
\itemize{
\item \code{group}: group label.
\item \code{data_mean}: observed mean response specific to the current study.
\item \code{data_sd}: observed standard deviation of the response
specific to the current study.
\item \code{data_lower}: lower bound of a simple frequentist 95\% confidence
interval of the observed mean specific to the current study.
\item \code{data_upper}: upper bound of a simple frequentist 95\% confidence
interval of the observed mean specific to the current study.
\item \code{data_n}: number of non-missing observations in the combined dataset
with all studies.
\item \code{data_N}: total number of observations (missing and non-missing)
in the combined dataset with all studies.
\item \verb{data_n_study_*}: number of non-missing observations separately
for each study.
The suffixes of these column names are integer study indexes.
Call \code{dplyr::distinct(hb_data(your_data), study, study_label)}
to see which study labels correspond to these integer indexes.
Note: the combined dataset for the mixture model
is just the current study. If all the \verb{data_n_study_*} results
across all studies
are desired, then call \code{hb_summary()} on a different model (e.g. pooled).
\item \verb{data_N_study_*}: same as \verb{data_n_study_*} except both missing and
non-missing observations are counted (total number of observations).
\item \code{response_mean}: Estimated posterior mean of the response
from the model specific to the current study.
Typically, the raw response is change from baseline,
in which case \code{response_mean} is estimating change from baseline.
\item \code{response_sd}: Estimated posterior standard deviation of the mean
response from the model specific to the current study.
\item \code{response_variance}: Estimated posterior variance of the mean
response from the model specific to the current study.
\item \code{response_lower}: Lower bound of a 95\% posterior interval on the mean
response from the model specific to the current study.
\item \code{response_upper}: Upper bound of a 95\% posterior interval on the mean
response from the model specific to the current study.
\item \code{response_mean_mcse}: Monte Carlo standard error of \code{response_mean}.
\item \code{response_sd_mcse}: Monte Carlo standard error of \code{response_sd}.
\item \code{response_lower_mcse}: Monte Carlo standard error of \code{response_lower}.
\item \code{response_upper_mcse}: Monte Carlo standard error of \code{response_upper}.
\item \code{diff_mean}: Estimated treatment effect from the model
specific to the current study.
\item \code{diff_lower}: Lower bound of a 95\% posterior interval on the treatment
effect from the model specific to the current study..
\item \code{diff_upper}: Upper bound of a 95\% posterior interval on the treatment
effect from the model specific to the current study..
\item \code{diff_mean_mcse}: Monte Carlo standard error of \code{diff_mean}.
\item \code{diff_lower_mcse}: Monte Carlo standard error of \code{diff_lower}.
\item \code{diff_upper_mcse}: Monte Carlo standard error of \code{diff_upper}.
\item \code{P(diff > EOI)}, \code{P(diff < EOI)}: CSF probabilities on the
treatment effect specified with the \code{eoi} and \code{direction}
arguments. Specific to the current study.
\item \code{effect_mean}: Estimated posterior mean of effect size
(treatment difference divided by residual standard deviation).
Specific to the current study.
\item \code{effect_lower}: Lower bound of a 95\% posterior interval of effect size
from the model. Specific to the current study.
\item \code{effect_upper}: Upper bound of a 95\% posterior interval of effect size
from the model. Specific to the current study.
\item \code{precision_ratio}: For the hierarchical model only,
a model-based mean of the precision ratio. Specific to the current study.
\item \code{precision_ratio_lower}: For the hierarchical model only, lower bound
of a model-based 95\% posterior interval of the precision ratio.
Specific to the current study.
\item \code{precision_ratio_upper}: For the hierarchical model only, upper bound
of a model-based 95\% posterior interval of the precision ratio.
Specific to the current study.
\item \verb{mix_prop_*}: For the mixture model only, posterior mixture proportions
of each of the mixture components. The last one is for the current study
and the first ones are for the historical studies. The suffixes of these
column names are the integer study indexes.
Call \code{dplyr::distinct(hb_data(your_data), study, study_label)}
to see which study labels correspond to these integer indexes.
}
}
\description{
Summarize a fitted model in a table.
}
\details{
The \code{hb_summary()} function post-processes the results from
the model. It estimates marginal means of the response,
treatment effect, and other quantities of interest.
}
\examples{
if (!identical(Sys.getenv("HB_TEST", unset = ""), "")) {
data <- hb_sim_pool(n_continuous = 2)$data
data$group <- sprintf("group\%s", data$group)
mcmc <- hb_mcmc_pool(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 50,
  n_iterations = 50
)
hb_summary(mcmc, data)
}
}
\seealso{
Other summary: 
\code{\link{hb_ess}()}
}
\concept{summary}
