% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_roster.R
\name{nba_commonteamroster}
\alias{nba_commonteamroster}
\title{\strong{Get NBA Stats API Team Roster}}
\usage{
nba_commonteamroster(
  league_id = "00",
  season = year_to_season(most_recent_nba_season() - 1),
  team_id = "1610612739",
  ...
)
}
\arguments{
\item{league_id}{league_id}

\item{season}{season}

\item{team_id}{team_id}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: Coaches, CommonTeamRoster

\strong{CommonTeamRoster}\tabular{ll}{
   col_name \tab types \cr
   TeamID \tab character \cr
   SEASON \tab character \cr
   LeagueID \tab character \cr
   PLAYER \tab character \cr
   NICKNAME \tab character \cr
   PLAYER_SLUG \tab character \cr
   NUM \tab character \cr
   POSITION \tab character \cr
   HEIGHT \tab character \cr
   WEIGHT \tab character \cr
   BIRTH_DATE \tab character \cr
   AGE \tab character \cr
   EXP \tab character \cr
   SCHOOL \tab character \cr
   PLAYER_ID \tab character \cr
   HOW_ACQUIRED \tab character \cr
}


\strong{Coaches}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   SEASON \tab character \cr
   COACH_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   COACH_NAME \tab character \cr
   IS_ASSISTANT \tab character \cr
   COACH_TYPE \tab character \cr
   SORT_SEQUENCE \tab character \cr
   SUB_SORT_SEQUENCE \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Team Roster}

\strong{Get NBA Stats API Team Roster}
}
\details{
\href{https://www.nba.com/stats/team/1610612756}{Team Roster}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_commonteamroster(season = year_to_season(most_recent_nba_season() - 1), team_id = '1610612739')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Roster Functions: 
\code{\link{nba_commonallplayers}()},
\code{\link{nba_commonplayerinfo}()}
}
\author{
Saiem Gilani
}
\concept{NBA Roster Functions}
