% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_league_dash.R
\name{nba_leaguedashteamshotlocations}
\alias{nba_leaguedashteamshotlocations}
\title{\strong{Get NBA Stats API League Dashboard Team Shot Locations}}
\usage{
nba_leaguedashteamshotlocations(
  conference = "",
  date_from = "",
  date_to = "",
  distance_range = "By Zone",
  division = "",
  game_scope = "",
  game_segment = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  measure_type = "Base",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  po_round = "",
  pace_adjust = "N",
  per_mode = "Totals",
  period = 0,
  player_experience = "",
  player_position = "",
  plus_minus = "N",
  rank = "N",
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  shot_clock_range = "",
  starter_bench = "",
  team_id = "",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{conference}{conference}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{distance_range}{distance_range}

\item{division}{division}

\item{game_scope}{game_scope}

\item{game_segment}{game_segment}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{measure_type}{measure_type}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{po_round}{po_round}

\item{pace_adjust}{pace_adjust}

\item{per_mode}{per_mode}

\item{period}{period}

\item{player_experience}{player_experience}

\item{player_position}{player_position}

\item{plus_minus}{plus_minus}

\item{rank}{rank}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{shot_clock_range}{shot_clock_range}

\item{starter_bench}{starter_bench}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: ShotLocations

\strong{ShotLocations}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   Restricted_Area_FGM \tab character \cr
   Restricted_Area_FGA \tab character \cr
   Restricted_Area_FG_PCT \tab character \cr
   In_The_Paint_Non_RA_FGM \tab character \cr
   In_The_Paint_Non_RA_FGA \tab character \cr
   In_The_Paint_Non_RA_FG_PCT \tab character \cr
   Mid_Range_FGM \tab character \cr
   Mid_Range_FGA \tab character \cr
   Mid_Range_FG_PCT \tab character \cr
   Left_Corner_3_FGM \tab character \cr
   Left_Corner_3_FGA \tab character \cr
   Left_Corner_3_FG_PCT \tab character \cr
   Right_Corner_3_FGM \tab character \cr
   Right_Corner_3_FGA \tab character \cr
   Right_Corner_3_FG_PCT \tab character \cr
   Above_the_Break_3_FGM \tab character \cr
   Above_the_Break_3_FGA \tab character \cr
   Above_the_Break_3_FG_PCT \tab character \cr
   Backcourt_FGM \tab character \cr
   Backcourt_FGA \tab character \cr
   Backcourt_FG_PCT \tab character \cr
   Corner_3_FGM \tab character \cr
   Corner_3_FGA \tab character \cr
   Corner_3_FG_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API League Dashboard Team Shot Locations}

\strong{Get NBA Stats API League Dashboard Team Shot Locations}
}
\details{
\href{https://www.nba.com/stats/teams/shooting}{Team Shooting by Shot Location}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_leaguedashteamshotlocations(league_id = '00', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA League Functions: 
\code{\link{nba_leaguedashlineups}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamclutch}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_leaguegamefinder}()},
\code{\link{nba_leaguegamelog}()},
\code{\link{nba_leaguelineupviz}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_leaguestandingsv3}()},
\code{\link{nba_leaguestandings}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playoffpicture}()},
\code{\link{nba_shotchartleaguewide}()}

Other NBA Shooting Functions: 
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_shotchartdetail}()},
\code{\link{nba_shotchartleaguewide}()},
\code{\link{nba_shotchartlineupdetail}()},
\code{\link{nba_teamdashboardbyshootingsplits}()}
}
\author{
Saiem Gilani
}
\concept{NBA League Functions}
\concept{NBA Shooting Functions}
