% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_player.R
\name{nba_playernextngames}
\alias{nba_playernextngames}
\title{\strong{Get NBA Stats API Player Next N Games}}
\usage{
nba_playernextngames(
  league_id = "",
  number_of_games = 2147483647,
  player_id = "2544",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{number_of_games}{N in number of games}

\item{player_id}{Player ID}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: NextNGames

\strong{NextNGames}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   GAME_DATE \tab character \cr
   HOME_TEAM_ID \tab character \cr
   VISITOR_TEAM_ID \tab character \cr
   HOME_TEAM_NAME \tab character \cr
   VISITOR_TEAM_NAME \tab character \cr
   HOME_TEAM_ABBREVIATION \tab character \cr
   VISITOR_TEAM_ABBREVIATION \tab character \cr
   HOME_TEAM_NICKNAME \tab character \cr
   VISITOR_TEAM_NICKNAME \tab character \cr
   GAME_TIME \tab character \cr
   HOME_WL \tab character \cr
   VISITOR_WL \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Player Next N Games}

\strong{Get NBA Stats API Player Next N Games}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_playernextngames(player_id = '2544')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Player Functions: 
\code{\link{nba_infographicfanduelplayer}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playerawards}()},
\code{\link{nba_playercareerbycollegerollup}()},
\code{\link{nba_playercareerbycollege}()},
\code{\link{nba_playercareerstats}()},
\code{\link{nba_playercompare}()},
\code{\link{nba_playerdashboardbyclutch}()},
\code{\link{nba_playerdashboardbygamesplits}()},
\code{\link{nba_playerdashboardbygeneralsplits}()},
\code{\link{nba_playerdashboardbylastngames}()},
\code{\link{nba_playerdashboardbyopponent}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_playerdashboardbyteamperformance}()},
\code{\link{nba_playerdashboardbyyearoveryear}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_playerestimatedmetrics}()},
\code{\link{nba_playerfantasyprofilebargraph}()},
\code{\link{nba_playerfantasyprofile}()},
\code{\link{nba_playergamelogs}()},
\code{\link{nba_playergamelog}()},
\code{\link{nba_playergamestreakfinder}()},
\code{\link{nba_playerheadshot}()},
\code{\link{nba_playerindex}()},
\code{\link{nba_playerprofilev2}()},
\code{\link{nba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{NBA Player Functions}
