% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_player.R
\name{nba_playervsplayer}
\alias{nba_playervsplayer}
\title{\strong{Get NBA Stats API Player vs Player}}
\usage{
nba_playervsplayer(
  date_from = "",
  date_to = "",
  game_segment = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  measure_type = "Base",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  pace_adjust = "N",
  per_mode = "Totals",
  period = 0,
  player_id = "2544",
  plus_minus = "N",
  rank = "N",
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  vs_conference = "",
  vs_division = "",
  vs_player_id = "203076",
  ...
)
}
\arguments{
\item{date_from}{date_from}

\item{date_to}{date_to}

\item{game_segment}{game_segment}

\item{last_n_games}{last_n_games}

\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{location}{location}

\item{measure_type}{measure_type}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{pace_adjust}{pace_adjust}

\item{per_mode}{per_mode}

\item{period}{period}

\item{player_id}{Player ID}

\item{plus_minus}{plus_minus}

\item{rank}{rank}

\item{season}{Season - format 2020-21}

\item{season_segment}{season_segment}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{vs_player_id}{vs_player_id}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: OnOffCourt, Overall, PlayerInfo, ShotAreaOffCourt,
ShotAreaOnCourt, ShotAreaOverall, ShotDistanceOffCourt, ShotDistanceOnCourt,
ShotDistanceOverall, VsPlayerInfo

\strong{Overall}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   NBA_FANTASY_PTS \tab character \cr
}


\strong{OnOffCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   NBA_FANTASY_PTS \tab character \cr
}


\strong{ShotDistanceOverall}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotDistanceOnCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GROUP_VALUE \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotDistanceOffCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GROUP_VALUE \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotAreaOverall}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotAreaOnCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GROUP_VALUE \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{ShotAreaOffCourt}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   VS_PLAYER_ID \tab character \cr
   VS_PLAYER_NAME \tab character \cr
   COURT_STATUS \tab character \cr
   GROUP_VALUE \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
}


\strong{PlayerInfo}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   DISPLAY_FIRST_LAST \tab character \cr
   DISPLAY_LAST_COMMA_FIRST \tab character \cr
   DISPLAY_FI_LAST \tab character \cr
   BIRTHDATE \tab character \cr
   SCHOOL \tab character \cr
   COUNTRY \tab character \cr
   LAST_AFFILIATION \tab character \cr
}


\strong{VsPlayerInfo}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   DISPLAY_FIRST_LAST \tab character \cr
   DISPLAY_LAST_COMMA_FIRST \tab character \cr
   DISPLAY_FI_LAST \tab character \cr
   BIRTHDATE \tab character \cr
   SCHOOL \tab character \cr
   COUNTRY \tab character \cr
   LAST_AFFILIATION \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Player vs Player}

\strong{Get NBA Stats API Player vs Player}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_playervsplayer(player_id = '2544', vs_player_id = '203076')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Player Functions: 
\code{\link{nba_infographicfanduelplayer}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playerawards}()},
\code{\link{nba_playercareerbycollegerollup}()},
\code{\link{nba_playercareerbycollege}()},
\code{\link{nba_playercareerstats}()},
\code{\link{nba_playercompare}()},
\code{\link{nba_playerdashboardbyclutch}()},
\code{\link{nba_playerdashboardbygamesplits}()},
\code{\link{nba_playerdashboardbygeneralsplits}()},
\code{\link{nba_playerdashboardbylastngames}()},
\code{\link{nba_playerdashboardbyopponent}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_playerdashboardbyteamperformance}()},
\code{\link{nba_playerdashboardbyyearoveryear}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_playerestimatedmetrics}()},
\code{\link{nba_playerfantasyprofilebargraph}()},
\code{\link{nba_playerfantasyprofile}()},
\code{\link{nba_playergamelogs}()},
\code{\link{nba_playergamelog}()},
\code{\link{nba_playergamestreakfinder}()},
\code{\link{nba_playerheadshot}()},
\code{\link{nba_playerindex}()},
\code{\link{nba_playernextngames}()},
\code{\link{nba_playerprofilev2}()}
}
\author{
Saiem Gilani
}
\concept{NBA Player Functions}
