% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hospital_attribute.R
\name{get_hospital_attribute}
\alias{get_hospital_attribute}
\title{Get hospital attribute}
\usage{
get_hospital_attribute(x, key = "hospital_id", value = "hospital_short_name")
}
\arguments{
\item{x}{A character vector of values that refer to hospitals, can be either
the hospital identifier (e.g. \code{"h0003"}), its acronym (e.g. \code{"HB"}), the
shortened name (\code{"H de Braga"}) or the full name (\code{"Hospital de Braga, EPE"}). Indicate how \code{x} should be interpreted with the parameter \code{key}.}

\item{key}{A string indicating the type of values in \code{x}: \code{"hospital_id"},
\code{"hospital_acronym"}, \code{"hospital_short_name"} or \code{"hospital_full_name"}.}

\item{value}{A string indicating the hospital attribute to be returned, can
be any of the columns of \code{\link{hospitals}}.}
}
\value{
A character vector of hospital attributes.
}
\description{
\code{get_hospital_attribute} retrieves one of the variables of \code{\link{hospitals}}
as indicated in \code{x}. Hospitals in \code{x} can be specified by the: (i) hospital
identifier, (ii) acronym, or the (iii) shortened or (iv) full version of the
hospital name.
}
\examples{
# Get the short name of a hospital
# (same as get_hospital_attribute('h0001', value = 'hospital_short_name'))
get_hospital_attribute('h0001')

# Or get instead the full name
get_hospital_attribute('h0001', value = 'hospital_full_name')

# Map the hospital short name to its full name
get_hospital_attribute('IPO de Lisboa', key = 'hospital_short_name', value = 'hospital_full_name')

}
