% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batting_basics.R
\name{bat_sr}
\alias{bat_sr}
\title{Batters Strike Rate}
\usage{
bat_sr(runs_scored, balls_faced)
}
\arguments{
\item{runs_scored}{A singular value of the runs scored by a batter.}

\item{balls_faced}{A singular value of balls faced by a batter.
Overs can be converted into \code{balls_faced} using \code{\link{overs_to_balls}}}
}
\value{
A singular value showing the batter's strike rate per 100 Balls.
}
\description{
Calculates a batter's strike rate over a number of innings.
}
\section{Additional Information}{

A batting strike rate is the average number of runs scored per 100 balls.
For example, a strike rate of 135 implies a batter would score 135 runs in a 100 balls.
A higher number indicates the batter scores at faster rate.
More info \href{https://en.wikipedia.org/wiki/Strike_rate#Batting_strike_rate}{here.}
}

\examples{
bat_sr(runs_scored = 568, balls_faced = 600)
total_runs <- sum(c(45, 123, 56, 12, 192, 34, 78, 3, 25))
total_balls <- sum(c(50, 120, 78, 3, 226, 36, 45, 12, 30))
bat_sr(
  runs_scored = total_runs,
  balls_faced = total_balls
)
}
