% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle_control.R
\name{hurdle_control}
\alias{hurdle_control}
\title{Control Parameters for Hurdle Model Count Data Regression}
\usage{
hurdle_control(a = 1, b = 1, size = 1, beta.prior.mean = 0,
  beta.prior.sd = 1000, beta.tune = 1, pars.tune = 0.2, lam.start = 1,
  mu.start = 1, sigma.start = 1, xi.start = 1)
}
\arguments{
\item{a}{shape parameter for gamma prior distributions.}

\item{b}{rate parameter for gamma prior distributions.}

\item{size}{size parameter for negative binomial likelihood distributions.}

\item{beta.prior.mean}{mu parameter for normal prior distributions.}

\item{beta.prior.sd}{standard deviation for normal prior distributions.}

\item{beta.tune}{Markov-chain tuning for regression coefficient estimation.}

\item{pars.tune}{Markov chain tuning for parameter estimation of 'extreme' 
observations distribution.}

\item{lam.start}{initial value for the poisson likelihood lambda parameter.}

\item{mu.start}{initial value for the negative binomial or log normal 
likelihood mu parameter.}

\item{sigma.start}{initial value for the generalized pareto likelihood
sigma parameter.}

\item{xi.start}{initial value for the generalized pareto likelihood 
xi parameter.}
}
\value{
A list of all input values.
}
\description{
Various parameters for fitting control of hurdle 
model regression using \code{\link{hurdle}}.
}
\seealso{
\code{\link{hurdle}}
}
\author{
Taylor Trippe <\email{ttrippe@luc.edu}> \cr
Earvin Balderama <\email{ebalderama@luc.edu}>
}
