% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_ts.R
\name{arima_arnn}
\alias{arima_arnn}
\title{Hybrid ARIMA ARNN Forecasting Model}
\usage{
arima_arnn(y, n, PI = FALSE, ret_fit = FALSE)
}
\arguments{
\item{y}{A numeric vector or time series}

\item{n}{An integer specifying the forecast horizon}

\item{PI}{A logical flag (default = \code{FALSE}) for generating the prediction interval.}

\item{ret_fit}{A logical flag specifying that the fitted values of the model on the
training set should be returned if true, otherwise, false (default)}
}
\value{
The forecast of the time series of size \code{n} is generated along with the optional
output of fitted values (\code{ret_fit} = TRUE) and confidence interval (\code{PI} = TRUE)
for the forecast.
}
\description{
Hybrid ARIMA ARNN Forecasting Model
}
\examples{
arima_arnn(y = datasets::lynx, n = 3)


}
\references{
\itemize{
\item Chakraborty, T., Chattopadhyay, S., & Ghosh, I. (2019). Forecasting dengue epidemics using a
hybrid methodology. Physica A: Statistical Mechanics and its Applications, 527, 121266.

\item Chakraborty, T., Ghosh, I., Mahajan, T., & Arora, T. (2022). Nowcasting of COVID-19 confirmed
cases: Foundations, trends, and challenges. Modeling, Control and Drug Development for COVID-19
Outbreak Prevention, 1023-1064.}
}
