% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_ts.R
\name{arima_warima}
\alias{arima_warima}
\title{Hybrid ARIMA WARIMA Forecasting Model}
\usage{
arima_warima(y, n, p = 5, q = 5, PI = FALSE, ret_fit = FALSE)
}
\arguments{
\item{y}{A numeric vector or time series}

\item{n}{An integer specifying the forecast horizon}

\item{p}{An integer indicating the maximum order of AR process. Default is 5.}

\item{q}{An integer indicating the maximum order of MA process. Default is 5.}

\item{PI}{A logical flag (default = \code{FALSE}) for generating the prediction interval.}

\item{ret_fit}{A logical flag specifying that the fitted values of the model on the
training set should be returned if true, otherwise, false (default)}
}
\value{
The forecast of the time series of size \code{n} is generated along with the optional
output of fitted values (\code{ret_fit} = TRUE) and confidence interval (\code{PI} = TRUE) for the forecast.
}
\description{
Hybrid ARIMA WARIMA Forecasting Model
}
\examples{
arima_warima(y = datasets::lynx, n = 3)

}
\references{
\itemize{
\item Chakraborty, T., & Ghosh, I. (2020). Real-time forecasts and risk assessment of novel
coronavirus (COVID-19) cases: A data-driven analysis. Chaos, Solitons & Fractals, 135, 109850.

\item Chakraborty, T., Ghosh, I., Mahajan, T., & Arora, T. (2022). Nowcasting of COVID-19 confirmed
cases: Foundations, trends, and challenges. Modeling, Control and Drug Development for COVID-19
Outbreak Prevention, 1023-1064.}
}
