% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_ts.R
\name{rw_arnn}
\alias{rw_arnn}
\title{Hybrid Random Walk ARNN Forecasting Model}
\usage{
rw_arnn(y, n, PI = FALSE, ret_fit = FALSE)
}
\arguments{
\item{y}{A numeric vector or time series}

\item{n}{An integer specifying the forecast horizon}

\item{PI}{A logical flag (default = \code{FALSE}) for generating the prediction interval.}

\item{ret_fit}{A logical flag specifying that the fitted values of the model on the
training set should be returned if true, otherwise, false (default)}
}
\value{
The forecast of the time series of size \code{n} is generated along with the optional
output of fitted values (\code{ret_fit} = TRUE) and confidence interval (\code{PI} = TRUE)
for the forecast.
}
\description{
Hybrid Random Walk ARNN Forecasting Model
}
\examples{
rw_arnn(y = datasets::lynx, n = 3)

}
