% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_modify_hydroMet.R
\name{modify_hydroMet}
\alias{modify_hydroMet}
\alias{modify_hydroMet,hydroMet_BDHI-method}
\alias{modify_hydroMet,hydroMet_CR2-method}
\alias{modify_hydroMet,hydroMet_DGI-method}
\alias{modify_hydroMet,hydroMet_IANIGLA-method}
\title{Modify data inside a specific slot}
\usage{
modify_hydroMet(
  obj,
  name = NA_character_,
  colName = NA_character_,
  colNum = 2,
  FUN = NULL,
  ...
)

\S4method{modify_hydroMet}{hydroMet_BDHI}(
  obj,
  name = NA_character_,
  colName = NA_character_,
  colNum = 2,
  FUN = NULL,
  ...
)

\S4method{modify_hydroMet}{hydroMet_CR2}(
  obj,
  name = NA_character_,
  colName = NA_character_,
  colNum = 2,
  FUN = NULL,
  ...
)

\S4method{modify_hydroMet}{hydroMet_DGI}(
  obj,
  name = NA_character_,
  colName = NA_character_,
  colNum = 2,
  FUN = NULL,
  ...
)

\S4method{modify_hydroMet}{hydroMet_IANIGLA}(
  obj,
  name = NA_character_,
  colName = NA_character_,
  colNum = 1,
  FUN = NULL,
  ...
)
}
\arguments{
\item{obj}{hydroMet_XXX subclass object. See \link{hydroMet_BDHI}, \link{hydroMet_DGI}, \link{hydroMet_IANIGLA} or \link{hydroMet_CR2}.}

\item{name}{string with the slot name of the data frame.}

\item{colName}{string with the new column name (from \code{FUN}).}

\item{colNum}{numeric value with the data frame column where to apply \code{FUN}. It must be > 1 (except in 'IANIGLA' subclass).}

\item{FUN}{the function name.}

\item{...}{\code{FUN} arguments to pass.}
}
\value{
The same hydroMet subclass provided in \code{obj} with an extra column.
}
\description{
Apply a pre-defined (e.g.: \link{movAvg}, \link{fill_value} or \link{Qmm_to_Dm}) or user defined function to an existing series inside a slot.
}
\section{Functions}{
\itemize{
\item \code{modify_hydroMet,hydroMet_BDHI-method}: modify method for BDHI class

\item \code{modify_hydroMet,hydroMet_CR2-method}: modify method for CR2 class

\item \code{modify_hydroMet,hydroMet_DGI-method}: modify method for DGI class

\item \code{modify_hydroMet,hydroMet_IANIGLA-method}: modify method for IANIGLA class
}}

\examples{
# Create BDHI hydro-met station
guido <- create_hydroMet(class_name = 'BDHI')

# List with meteorological variables (slots in BDHI's object)
cargar <- list('precip', 'Qmd', 'Qmm')

# Now assign as names the files
hydro_files   <- list.files( system.file('extdata', package = "hydroToolkit"), pattern = 'Guido' )
names(cargar) <- hydro_files

# Build the object with the met records
guido <- build_hydroMet(obj = guido, slot_list = cargar, 
               path = system.file('extdata', package = "hydroToolkit") )

}
