% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis-api.R
\name{group}
\alias{group}
\title{Operate with group}
\source{
\url{https://h.readthedocs.io/en/latest/api-reference/v1/}
}
\usage{
group(
  group_id,
  action = c("fetch", "update", "fetch_members"),
  ...,
  api_path = get_hs_host(),
  api_key = NULL
)
}
\arguments{
\item{group_id}{Group ID}

\item{action}{Action to process, Default: `fetch`}

\item{...}{Parameters for update group information, more details can be found
in hypothesis documentation.}

\item{api_path}{The hypothesis API path, can be specify by `hypothesis.api.api_path` option or
`HYPOTHESIS_API_PATH` environment variable. Default: `https://hypothes.is/api/`.}

\item{api_key}{User api key, generated on the platform.}
}
\description{
Operate with group
}
\examples{
\dontrun{
group("group_id")
group("group_id", action = "update", name = "updated text", description = "desc")
group("group_id", action = "fetch_members")
}
}
