% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_values.R
\name{cldr_characters}
\alias{cldr_characters}
\title{Get localized values from the \link{characters} dataset}
\usage{
cldr_characters(
  locale = "en",
  element = characters_elements$exemplar_characters
)
}
\arguments{
\item{locale}{The locale ID for which to obtain the data from the
\link{characters} table.}

\item{element}{The element from which information will be obtained for the
specified \code{locale}.}
}
\value{
Either a named list or a length one character vector, depending on
the \code{element} value.
}
\description{
The \link{characters} table contains information on the usage of characters
and exemplar character sets across 574 locales. The
\code{cldr_characters()} function allows one to extract element values from the
table by supplying the \code{locale} and one of the following element names:
\itemize{
\item \code{"exemplar_characters"}
\item \code{"auxiliary"}
\item \code{"index"}
\item \code{"numbers"}
\item \code{"punctuation"}
\item \code{"more_info"}
\item \code{"ellipsis"}
\item \code{"leninent_scope_general"}
\item \code{"leninent_scope_date"}
\item \code{"leninent_scope_number"}
\item \code{"stricter_scope_number"}
}
}
