% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{undoIMRMCdf}
\alias{undoIMRMCdf}
\title{Convert a doIMRMC formatted data frame to a standard data frame
with all factors.}
\usage{
undoIMRMCdf(df.MRMC)
}
\arguments{
\item{df.MRMC}{This data frame includes columns for readerID, caseID, modalityID, score.
Each row is a reader x case x modality observation from the study
In addition to observations from the study,
    this data frame requires rows specifying the truth for each caseID.
For truth specifications, the readerID needs to equal "truth" or "-1",
    modalityID can be anything ("truth" is a good choice),
    and score should be 0 for signal-absent normal case, 1 for signal-present disease case.}
}
\value{
output a data frame with columns readerID, caseID, modalityID, score, truth
}
\description{
Convert a doIMRMC formatted data frame to a standard data frame
with all factors.
}
\details{
Delete rows specifying truth and put the truth information on every row.
}
