% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_ibd_patterns.R
\name{multi_ibd_patterns}
\alias{multi_ibd_patterns}
\title{Compute probabilities of minimal multi-id IBD patterns}
\usage{
multi_ibd_patterns(
  pedigree,
  ids = pedtools::leaves(pedigree),
  recombination_rate_by_locus = numeric()
)
}
\arguments{
\item{pedigree}{Pedigree in \code{\link[pedtools:ped]{pedtools::ped}} form.}

\item{ids}{Ids for which IBD is observed. Defaults to \code{\link[pedtools:ped_subgroups]{pedtools::leaves}}\code{(pedigree)}.}

\item{recombination_rate_by_locus}{Optionally a numeric vector with recombination rates.}
}
\value{
DataFrame
}
\description{
For two full siblings at one locus, it is well known that there are three distinct minimal IBD patterns
with probabilities 0.25, 0.5 and 0.25. The \code{\link[ribd:multiPersonIBD]{ribd::multiPersonIBD}} function
generalises the computation of these patterns and their probabilities to more than
two ids The \code{multi_ibd_patterns} function further generalises the computation
to patterns across multiple loci.
}
\examples{
# Compute IBD patterns for two full siblings...
multi_ibd_patterns(pedtools::nuclearPed(nch = 2))

# ... and the generalisation to three siblings
multi_ibd_patterns(pedtools::nuclearPed(nch = 3))

# Two full siblings at two tightly linked loci
multi_ibd_patterns(pedtools::nuclearPed(nch = 2),
                   recombination_rate_by_locus = 0.01)
}
