% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discounting.R
\name{discounting}
\alias{discounting}
\title{Discounting masses}
\usage{
discounting(MassIn, alpha)
}
\arguments{
\item{MassIn}{Matrix with \eqn{nb} columns and \eqn{2^n} rows. Parameter \eqn{n} is the number of elements in the discernment frame and \eqn{nb} is the number of experts. Each column is a bba. If there is only one bba, the input could be a vector with length \eqn{2^n}.}

\item{alpha}{Discounting factor. A number or a vector with length of \code{ncol(MassIn)}. If it is a number, all the bbas will be discounted using the same factor. If it is a vector with length \code{ncol{MassIn}}, the bbas will be discounted using the corresponding factor.}
}
\value{
Mass matrix with the same dimension as MassIn. The discounted masses, each column is a piece of mass. If the input is a vector, the output is also a vector.
}
\description{
Discount masses using  given factors
}
\examples{
## The conflict table for two experts in a discernment frame with three elements
m1=c(0,0.4, 0.1, 0.2, 0.2, 0, 0, 0.1);
m2=c(0,0.2, 0.3, 0.1, 0.1, 0, 0.2, 0.1);
discounting(m1,0.95)
# if only one factor is given, all the masses are discounted using the same factor
discounting(cbind(m1,m2),0.95)
# if the factor vector is given, the masses are discounted using the corresponding factor
discounting(cbind(m1,m2),c(0.95,0.9))
}
