% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_contact_list.R
\name{get_contact_list}
\alias{get_contact_list}
\title{Get Export of a Database or contact List}
\usage{
get_contact_list(
  pod_number,
  session_access_token,
  list_id,
  start_date,
  end_date,
  export_format = "CSV",
  move_to_ftp = FALSE,
  confirm_email = ""
)
}
\arguments{
\item{pod_number}{Pod number is the number in the URL, e.g.
engage1.silverpop.com.}

\item{session_access_token}{Access token obtained during this session.}

\item{list_id}{Acoustic id for the database or contact list (string).}

\item{start_date}{Filter for emails sent on or after this date.}

\item{end_date}{Filter for emails sent on or before this date.}

\item{export_format}{Acoustic provides three delimiter file types:
CSV, PIPE, TAB. CSV is the default used here.}

\item{move_to_ftp}{If TRUE (default is FALSE) will send files to SFTP server
instead of being able to download manually from the portal.}

\item{confirm_email}{Optional argument to specify an email address
where IBM will let you know when the job has completed.}
}
\value{
A vector with the Job Id.
}
\description{
This function submits a job to Acoustic that exports a particular
database or contact list based on the list id.  Various criteria
are available to filter the export. Some, but not all, of these
have been built into the parameters of this function. Reading the
IBM Acoustic documentation is useful:
https://developer.ibm.com/customer-engagement/tutorials/
export-from-a-database/
}
\details{
Job results are available as exports in the Silverpop portal by
going to Resources -> Data Jobs.

It is not recommended that these authentication parameters be
stored directly in your code. There are various methods and
packages available that are more secure; this package does not
require you to use any one in particular.
}
\examples{
\dontrun{
access_token <- acoustic_auth(org_client_id = "abc",
org_client_secret = "xyz",
my_refresh_token = "123")

job_id <- get_contact_list(pod_number, access_token, list_id,
"2020-01-01", "2020-01-05", "PIPE")
}
}
