% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{str.ichimoku}
\alias{str.ichimoku}
\title{Display the Structure of Ichimoku Objects}
\usage{
\method{str}{ichimoku}(object, ...)
}
\arguments{
\item{object}{an object of class \sQuote{ichimoku}.}

\item{...}{arguments passed to or from other methods.}
}
\value{
Invisible NULL. A compact display of the structure of the object is
    output to the console.
}
\description{
Compactly display the internal structure of ichimoku objects.
}
\details{
This function is an S3 method for the generic function str() for
    class \sQuote{ichimoku}. It can be invoked by calling str(x) on an object
    \sQuote{x} of class \sQuote{ichimoku}.
}
\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
str(cloud)

strat <- strat(cloud)
str(strat)

}
