% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_functions.R
\name{data_prep}
\alias{data_prep}
\title{Prepare Data for Interval-Censored Model}
\usage{
data_prep(X)
}
\arguments{
\item{X}{A matrix or data frame of interval-censored data where each row contains the lower and upper bounds of the interval for each observation.}
}
\value{
A list containing:
\describe{
  \item{tau}{Unique time points.}
  \item{m}{The number of unique time points (excluding infinity if present).}
  \item{L_Rc}{Indices of observations where the event is in the intersection of L group and the complement of R group. 
The L group consists of samples with left intervals time <= min(all right intervals time). 
The R group consists of samples with infinity right interval time.}
  \item{Lc_R}{Indices of observations where the event is in the intersection of the complement of L group and R group.}
  \item{Lc_Rc}{Indices of observations where the event is in the intersection of the complement of L group and the complement of R group.}
  \item{ri}{Indices corresponding to the right bounds of the intervals in \code{tau}.}
  \item{li}{Indices corresponding to the left bounds of the intervals in \code{tau}.}
  \item{tau_no_Inf}{Unique time points excluding infinity.}
  \item{weight}{Weights for each unique interval.}
  \item{X}{Processed matrix of interval-censored data with unique rows.}
}
}
\description{
This function processes interval-censored data and prepares various components needed for model fitting, including unique time points, censoring intervals, and weights.
}
