% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportHudgens.R
\name{graphfromIntervals}
\alias{graphfromIntervals}
\title{Construct Graph from censoring/truncation intervals}
\usage{
graphfromIntervals(intervals)
}
\arguments{
\item{intervals}{A data.frame with 3 columns containing half-open intervals (left open, right closed)
and an indicator whether the interval results from a censored transition
 or truncation:
#'\describe{
  \item{\code{L}:}{Left side of interval;}
  \item{\code{R}:}{Right side of interval;}
  \item{\code{cens}:}{Indicator whether interval resulted from censoring or truncation
  (1 = censoring, 0 = truncation);}
} Note that the truncation intervals need to be in the form (N, Inf] with N a numeric value.}
}
\value{
Returns an \code{'igraph'} object containing the graph with vertices 
representing the intervals and edges between the vertices if the intervals 
intersect. The vertices will be named accordingly, starting with a 'T' when 
representing a truncation interval and 'C' when representing a censoring 
interval.
}
\description{
Given intervals, construct a graph containing vertices 
representing these intervals and edges between the vertices if the intervals 
intersect. See Hudgens (2005).
}
\references{
Michael G. Hudgens, On Nonparametric Maximum Likelihood Estimation with 
Interval Censoring and Left Truncation, Journal of the Royal Statistical Society 
Series B: Statistical Methodology, Volume 67, Issue 4, September 2005, Pages 573-587,
 \doi{10.1111/j.1467-9868.2005.00516.x}
}
