% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocking.R
\name{Blocks}
\alias{Blocks}
\title{Create blocks (sub-designs) from a given design.}
\usage{
Blocks(
  des,
  n.blocks,
  n.alts,
  blocking.iter = 50,
  no.choice = FALSE,
  alt.cte = NULL
)
}
\arguments{
\item{des}{The design to be distributed into blocks (sub-designs).}

\item{n.blocks}{A numeric value indicating the desired number of blocks to
create out of the provided design.}

\item{n.alts}{The number of alternatives in each choice set.}

\item{blocking.iter}{A numeric value indicating the maximum number of iterations
for optimising the level balance in the blocks. The default value is 50.}

\item{no.choice}{A logical value indicating whether a no choice alternative
is added to each choice set in the provided design. The default is \code{FALSE}.}

\item{alt.cte}{A binary vector indicating for each alternative whether an
alternative specific constant is present in the design. The default is \code{NULL}.}
}
\value{
A list of blocks from the original design is returned. Additionally, the
frequency of every level in each block is returned.
}
\description{
This function breaks down a design output from \code{Modfed} or \code{CEA} into a specified number of blocks
while aiming to maintain balance in levels frequency across the resulting blocks.
}
\details{
The argument \code{n.blocks} specifies the number of blocks to create. The algorithm strives to distribute the choice sets of the design evenly among the blocks, while maintaining level balance across them. The choice sets are assigned sequentially to the blocks, aiming to maintain the closest possible level balance among them up to that stage in the sequence. Hence, the algorithm runs different iterations, during each of which the choice sets in the design are shuffled randomly. The argument \code{blocking.iter} specifies the maximum number of these iterations.

If the design has a no.choice alternative then \code{no.choice} should be set to \code{TRUE}. Additionally, \code{asc.col} should indicate the number of alternative specific constants that are included in the design, if any.

This functionality is also available as an argument (\code{n.blocks}) when creating an efficient design using
\code{\link{Modfed}} or \code{\link{CEA}}.

Note: To make sure the code works well, the names of the variables in the provided
design should be aligned with variable names that the function \code{Profiles} produces. For
example, if attribute 1 is a dummy variable of 3 levels then its corresponding columns
should have numbered names such as: var11 and var12, or (if labelled) price1 and price2, for instance.
}
\examples{
\donttest{
# DB-efficient designs
# 3 Attributes with 3 levels, all dummy coded. 1 alternative specific constant = 7 parameters
cand.set <- Profiles(lvls = c(3, 3, 3), coding = c("D", "D", "D"))
mu <- c(0.5, 0.8, 0.2, -0.3, -1.2, 1.6, 2.2) # Prior parameter vector
v <- diag(length(mu)) # Prior variance.
set.seed(123) 
pd <- MASS::mvrnorm(n = 10, mu = mu, Sigma = v) # 10 draws.
p.d <- list(matrix(pd[,1], ncol = 1), pd[,2:7])
design <- Modfed(cand.set = cand.set, n.sets = 8, n.alts = 2, 
       alt.cte = c(1, 0), parallel = FALSE, par.draws = p.d)
Blocks(design$BestDesign$design, n.blocks = 2, n.alts = 2, alt.cte = c(1, 0))
}
}
