% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idmact_subj.R
\name{idmact_subj}
\alias{idmact_subj}
\title{Interpret Differences in Mean ACT Scores at the Subject Level}
\usage{
idmact_subj(
  df = NULL,
  df_map = NULL,
  raw,
  inc = 1,
  map_raw,
  map_scale,
  mcent_subj = function(x) mean(x, na.rm = TRUE),
  na.rm.max = TRUE
)
}
\arguments{
\item{df}{An optional data frame containing the variable for raw scores.}

\item{df_map}{A data frame that maps raw scores to their corresponding scale
scores.}

\item{raw}{A list of raw scores, or a string representing the column name in
'df' containing raw scores.}

\item{inc}{A numeric value used to increment raw scores to calculate adjusted
scores, or a function to perform this incrementing operation.}

\item{map_raw}{A list containing the domain of raw scores for the raw-to-scale
score mapping, or a string representing the column name in 'df' or 'df_map'
that contains this domain.}

\item{map_scale}{A list containing the range of scale scores for the
raw-to-scale score mapping, or a string representing the column name in 'df'
or 'df_map' that contains this range.}

\item{mcent_subj}{A function that defines the measure of central tendency to be used.
The default is 'mean'.}

\item{na.rm.max}{A logical value. If TRUE, missing values are removed before calculating the
maximum raw and scale values in the mapping. If FALSE, missing values are not
removed.}
}
\value{
A list containing the following elements:
\itemize{
\item 'deltas': the difference between the mean adjusted and unadjusted scale
scores,
\item 'm_scale': a list with the mean adjusted ('adj') and unadjusted ('unadj')
scale scores,
\item 'scale': a list with the individual adjusted ('adj') and unadjusted ('unadj')
scale scores,
\item 'raw': a list with the individual adjusted ('adj') and unadjusted ('unadj')
raw scores.
}
}
\description{
This function implements an algorithm to analyze differences in subject level
scores.It first adjusts raw scores for each student, maps these adjusted raw
scores to scale scores using the provided raw-to-scale score mapping (note:
perfect raw scores are always converted to the maximum allowable scale score
despite the adjustment in the previous step), then calculates the mean adjusted
and unadjusted scale scores across all observations. The difference (delta)
between these two mean scores is then computed. The adjustment and calculation
method follows Schiel's (1998) methodology, but can also be customized with
user-defined parameters and functions.
}
\examples{
raw_scores = list(1, 2, 3, 4, 5)
map_raw_scores = list(1, 2, 3, 4, 5)
map_scale_scores = list(20, 21, 22, 23, 24)
idmact_subj(raw = raw_scores,
            map_raw = map_raw_scores,
            map_scale = map_scale_scores)
}
\references{
Schiel, J. C. (1998). Interpreting differences in ACT composite scores
(ACT Research Report Series 98-1). ACT, Inc. URL:
https://www.act.org/content/dam/act/unsecured/documents/ACT_RR98-01.pdf
}
