% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_idx.R
\name{read_idx}
\alias{read_idx}
\title{Read an IDX file}
\usage{
read_idx(file_name, endian = "big")
}
\arguments{
\item{file_name}{character vector containing the name of
the file to be read}

\item{endian}{whether the file has "big" or "little" endian}
}
\description{
This function allows to read an IDX file
}
\examples{
m = matrix(1:16, nrow = 4)
file_name = file.path(tempdir(),"m.idx")
write_idx(m, file_name)  
mr = read_idx(file_name) 
}
