% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{maxp_one}
\alias{maxp_one}
\title{MaxP test for the indirect effect - Single mediator path}
\usage{
maxp_one(
  u1 = NULL,
  u2 = NULL,
  V1Dist = NULL,
  V1 = NULL,
  V1_VAR = NULL,
  V1_DF = NULL,
  V2Dist = NULL,
  V2 = NULL,
  V2_VAR = NULL,
  V2_DF = NULL,
  V2b = 0,
  V2b_VAR = 0,
  V2bmult = 1L,
  V1_V2_cov = 0,
  V1_V2b_cov = 0,
  V2_V2b_cov = 0,
  V1_0 = 0,
  V2_0 = 0,
  V2b_0 = 0
)
}
\arguments{
\item{u1, u2}{The U values to be used in the test. Given priority over estimates, but both must be supplied.}

\item{V1Dist}{String value specifying the distribution of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.}

\item{V1}{Value of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.}

\item{V1_VAR}{Value of the variance of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.}

\item{V1_DF}{Degrees of freedom for V1. Only needed if t-distribution is used.}

\item{V2Dist}{String value specifying the distribution of the estimate of the mediator (and interaction term) on the response.}

\item{V2}{Value of the estimate of the mediator on the response. Ignored if u1 and u2 are supplied.}

\item{V2_VAR}{Value of the variance of the estimate of the mediator on the response.. Ignored if u1 and u2 are supplied.}

\item{V2_DF}{Degrees of freedom for V2. Only needed if t-distribution is used..}

\item{V2b}{Value of the estimate of the effect of the interaction of the independent and mediator variable on the response. Ignored if u1 and u2 are supplied.}

\item{V2b_VAR}{Value of the variance of the estimate of the effect of the interaction of the independent and mediator variable on the response. Ignored if u1 and u2 are supplied.}

\item{V2bmult}{Value indicating the value of the independent variable used for the interaction. Typically 1.}

\item{V1_V2_cov}{Value of the covariance between V1 and V2. Typically 0 for fully observed data.}

\item{V1_V2b_cov}{Value of the covariance between V1 and V2b. Typically 0 for fully observed data.}

\item{V2_V2b_cov}{Value of the covariance between V2 and V2b.}

\item{V1_0}{Null value for V1.}

\item{V2_0}{Null value for V2.}

\item{V2b_0}{Null value for V2b.}
}
\value{
The p-value of the test in the form of the larger of the p-values for the individual parameters.
}
\description{
This function takes 
estimates and covariances, or 2 U values, for the maxP test 
for either one mediator of one path of an unordered mediation scenario.
If estimates are passed to the function, the user must specify 
what distribution is to be used to find the cumulative probabilities.
The maximum p-value is returned.
}
\examples{
maxp_one(u1 = .02, u2= .015)
}
